/*
 * Decompiled with CFR 0.152.
 */
package com.tsy.sdk.video;

import android.content.Context;
import android.hardware.Camera;
import android.media.AudioRecord;
import android.os.Process;
import android.support.annotation.NonNull;
import com.tsy.sdk.video.CameraHelper;
import com.tsy.sdk.video.MyOrientationDetector;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameFilter;
import org.bytedeco.javacv.FrameRecorder;

public class Recorder
implements Camera.PreviewCallback {
    private String TAG = "Recorder";
    private Builder mBuilder;
    private Frame mFrame;
    private FFmpegFrameRecorder mFFmpegFrameRecorder;
    private FFmpegFrameRecorder mFFmpegFrameRecorderL;
    private FFmpegFrameRecorder mFFmpegFrameRecorderV;
    private FFmpegFrameFilter mFFmpegFrameFilter;
    private AudioRecordRunnable mAudioRecordRunnable;
    private Thread mAudioThread;
    private AudioRecord mAudioRecord;
    private long mStartTime = 0L;
    private boolean mRecording = false;
    private boolean mRunAudioThread = false;
    private int sampleAudioRateInHz = 44100;
    private int frameRate = 30;

    Recorder(Builder builder) {
        this.mBuilder = builder;
        this.initRecorder();
    }

    public String getOutputPath() {
        return this.mBuilder.mOutputFilePath;
    }

    public boolean isRecording() {
        return this.mRecording;
    }

    public long getRecordingTime() {
        if (this.mStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.mStartTime;
    }

    public void switchCamera(Camera camera, int face) {
        this.mBuilder.switchCamera(camera, face);
        this.initFilter();
    }

    private void initRecorder() {
        Camera.Size previewSize = CameraHelper.getFullScreenPreviewSize(this.mBuilder.mContext, this.mBuilder.mCamera);
        this.mFrame = new Frame(previewSize.width, previewSize.height, 8, 2);
        this.mFFmpegFrameRecorderV = new FFmpegFrameRecorder(this.mBuilder.mOutputFilePath, this.mBuilder.mOutputWidth, this.mBuilder.mOutputHeight, 1);
        this.initFrameRecorder(this.mFFmpegFrameRecorderV);
        this.mFFmpegFrameRecorderL = new FFmpegFrameRecorder(this.mBuilder.mOutputFilePath, this.mBuilder.mOutputHeight, this.mBuilder.mOutputWidth, 1);
        this.initFrameRecorder(this.mFFmpegFrameRecorderL);
        this.mAudioRecordRunnable = new AudioRecordRunnable();
    }

    private void initFrameRecorder(FFmpegFrameRecorder frameRecorder) {
        frameRecorder.setFormat("mp4");
        frameRecorder.setVideoOption("preset", "ultrafast");
        frameRecorder.setFrameRate(this.frameRate);
        frameRecorder.setVideoQuality(0.0);
        frameRecorder.setAudioChannels(1);
        frameRecorder.setSampleRate(this.sampleAudioRateInHz);
    }

    private void initFilter() {
        Camera.Size previewSize = CameraHelper.getFullScreenPreviewSize(this.mBuilder.mContext, this.mBuilder.mCamera);
        Float outputRatio = Float.valueOf(1.0f * (float)this.mBuilder.mOutputHeight / (float)this.mBuilder.mOutputWidth);
        int cropWidth = (int)(outputRatio.floatValue() * (float)previewSize.height);
        int cropHeight = previewSize.height;
        int startX = 0;
        int startY = 0;
        int rotation = 90;
        boolean hflip = false;
        rotation = (rotation + this.mBuilder.mMyOrientationDetector.getOrientation()) % 360;
        if (this.mBuilder.mCameraFace == 1) {
            startX = previewSize.width - cropWidth;
            rotation = 270;
            rotation = (rotation - this.mBuilder.mMyOrientationDetector.getOrientation()) % 360;
            hflip = true;
        }
        String filters = this.generateFilters(cropWidth, cropHeight, startX, startY, rotation, hflip);
        this.mFFmpegFrameFilter = new FFmpegFrameFilter(filters, previewSize.width, previewSize.height);
        this.mFFmpegFrameFilter.setPixelFormat(26);
    }

    public void start() throws FrameRecorder.Exception, FrameFilter.Exception {
        if (this.mRecording) {
            return;
        }
        int rotation = this.mBuilder.mMyOrientationDetector.getOrientation();
        this.mFFmpegFrameRecorder = rotation == 0 || rotation == 180 ? this.mFFmpegFrameRecorderV : this.mFFmpegFrameRecorderL;
        this.initFilter();
        this.mBuilder.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
        this.mFFmpegFrameRecorder.start();
        this.mFFmpegFrameFilter.start();
        this.mRecording = true;
        this.mRunAudioThread = true;
        this.mAudioThread = new Thread(this.mAudioRecordRunnable);
        this.mAudioThread.start();
        this.mStartTime = System.currentTimeMillis();
    }

    public void stop() throws FrameRecorder.Exception, FrameFilter.Exception {
        if (!this.mRecording) {
            return;
        }
        this.mStartTime = 0L;
        this.mRunAudioThread = false;
        try {
            this.mAudioThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        this.mAudioThread = null;
        if (this.mFFmpegFrameRecorder != null && this.mRecording) {
            this.mRecording = false;
            this.mFFmpegFrameRecorder.stop();
            this.mFFmpegFrameRecorder.release();
            this.mFFmpegFrameFilter.stop();
            this.mFFmpegFrameFilter.release();
        }
    }

    private String generateFilters(int w, int h, int x, int y, int rotation, boolean hflip) {
        String filters = String.format("crop=w=%d:h=%d:x=%d:y=%d", w, h, x, y);
        for (int i = 0; i < rotation / 90; ++i) {
            filters = filters + ",transpose=clock";
        }
        if (hflip) {
            filters = filters + ",hflip";
        }
        return filters;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mFrame != null && this.mRecording) {
            ((ByteBuffer)this.mFrame.image[0].position(0)).put(data);
            try {
                Frame frame2;
                long t = 1000L * (System.currentTimeMillis() - this.mStartTime);
                if (t > this.mFFmpegFrameRecorder.getTimestamp()) {
                    this.mFFmpegFrameRecorder.setTimestamp(t);
                }
                this.mFFmpegFrameFilter.push(this.mFrame);
                while ((frame2 = this.mFFmpegFrameFilter.pull()) != null) {
                    this.mFFmpegFrameRecorder.record(frame2);
                }
            }
            catch (FrameFilter.Exception | FrameRecorder.Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class AudioRecordRunnable
    implements Runnable {
        private AudioRecordRunnable() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            int bufferSize = AudioRecord.getMinBufferSize((int)Recorder.this.sampleAudioRateInHz, (int)16, (int)2);
            Recorder.this.mAudioRecord = new AudioRecord(1, Recorder.this.sampleAudioRateInHz, 16, 2, bufferSize);
            ShortBuffer audioData = ShortBuffer.allocate(bufferSize);
            Recorder.this.mAudioRecord.startRecording();
            while (Recorder.this.mRunAudioThread) {
                int bufferReadResult = Recorder.this.mAudioRecord.read(audioData.array(), 0, audioData.capacity());
                audioData.limit(bufferReadResult);
                if (bufferReadResult <= 0 || Recorder.this.mFFmpegFrameRecorder == null || !Recorder.this.mRecording) continue;
                try {
                    Recorder.this.mFFmpegFrameRecorder.recordSamples(audioData);
                }
                catch (FrameRecorder.Exception e) {
                    e.printStackTrace();
                }
            }
            if (Recorder.this.mAudioRecord != null) {
                Recorder.this.mAudioRecord.stop();
                Recorder.this.mAudioRecord.release();
            }
        }
    }

    public static class Builder {
        private Context mContext = null;
        private Camera mCamera = null;
        private int mCameraFace = -1;
        private String mOutputFilePath = "";
        private int mOutputWidth = 0;
        private int mOutputHeight = 0;
        private MyOrientationDetector mMyOrientationDetector;

        public void switchCamera(Camera camera, int face) {
            this.mCamera = camera;
            this.mCameraFace = face;
        }

        public Builder context(@NonNull Context context) {
            this.mContext = context;
            return this;
        }

        public Builder camera(@NonNull Camera camera) {
            this.mCamera = camera;
            return this;
        }

        public Builder cameraFace(int face) {
            this.mCameraFace = face;
            return this;
        }

        public Builder outputFilePath(@NonNull String outputFilePath) {
            this.mOutputFilePath = outputFilePath;
            return this;
        }

        public Builder outputSize(int width, int height) {
            this.mOutputWidth = width;
            this.mOutputHeight = height;
            return this;
        }

        public Builder orientationDetector(@NonNull MyOrientationDetector myOrientationDetector) {
            this.mMyOrientationDetector = myOrientationDetector;
            return this;
        }

        public Recorder build() throws IllegalArgumentException {
            if (this.mContext == null) {
                throw new IllegalArgumentException("mContext\u4e3a\u7a7a");
            }
            if (this.mCamera == null) {
                throw new IllegalArgumentException("mCamera\u4e3a\u7a7a");
            }
            if (this.mCameraFace != 0 && this.mCameraFace != 1) {
                throw new IllegalArgumentException("mCameraFace\u975e\u6cd5");
            }
            this.checkFilePath(this.mOutputFilePath);
            if (this.mOutputWidth < 0 || this.mOutputHeight < 0) {
                throw new IllegalArgumentException("mOutputWidth mOutputHeight\u975e\u6cd5");
            }
            if (this.mMyOrientationDetector == null) {
                throw new IllegalArgumentException("mMyOrientationDetector\u4e3a\u7a7a");
            }
            return new Recorder(this);
        }

        private void checkFilePath(String filePath) throws IllegalArgumentException {
            if (filePath.length() == 0) {
                throw new IllegalArgumentException("mOutputFilePath\u4e3a\u7a7a");
            }
            File file = new File(filePath);
            if (file.exists()) {
                return;
            }
            if (filePath.endsWith(File.separator)) {
                throw new IllegalArgumentException("\u6587\u4ef6" + filePath + "\u683c\u5f0f\u975e\u6cd5\uff0c\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u76ee\u5f55\uff01");
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
        }
    }
}

