/*
 * Decompiled with CFR 0.152.
 */
package com.tsy.sdk.video;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.tsy.sdk.video.CameraHelper;
import com.tsy.sdk.video.R;
import java.util.ArrayList;

public class CameraPreviewView
extends FrameLayout {
    private CameraView mCameraView;
    private Camera mCamera;
    private int mWidth;
    private int mHeight;
    private Animation mFocusAnimation;
    private ImageView mFocusAnimationView;

    public CameraPreviewView(Context context) {
        this(context, null);
    }

    public CameraPreviewView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraPreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mFocusAnimationView = new ImageView(context);
        this.mFocusAnimationView.setVisibility(4);
        this.mFocusAnimationView.setImageResource(R.drawable.video_focus_icon);
        this.addView((View)this.mFocusAnimationView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.mFocusAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.focus_animation);
        this.mFocusAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                CameraPreviewView.this.mFocusAnimationView.setVisibility(4);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void init(Camera camera, int width, int height) {
        this.mCamera = camera;
        this.mWidth = width;
        this.mHeight = height;
        if (this.mCameraView != null) {
            this.removeView((View)this.mCameraView);
            this.mCameraView = null;
        }
        this.mCameraView = new CameraView(this.getContext());
        this.addView((View)this.mCameraView, 0);
        this.requestLayout();
    }

    public void switchCamera(Camera camera) {
        this.mCamera = camera;
        this.mCameraView.switchCamera();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mCamera == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = (int)((float)width / (1.0f * (float)this.mWidth / (float)this.mHeight));
        int wms = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int hms = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(wms, hms);
    }

    public class CameraView
    extends SurfaceView
    implements SurfaceHolder.Callback {
        private String TAG;
        private float mOldDist;

        public CameraView(Context context) {
            super(context);
            this.TAG = "CameraView";
            this.mOldDist = 1.0f;
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
        }

        private void initCamera() {
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            CameraPreviewView.this.mCamera.stopPreview();
            Camera.Parameters parameters = CameraPreviewView.this.mCamera.getParameters();
            Camera.Size previewSize = CameraHelper.getFullScreenPreviewSize(this.getContext(), CameraPreviewView.this.mCamera);
            parameters.setPreviewSize(previewSize.width, previewSize.height);
            CameraPreviewView.this.mCamera.setParameters(parameters);
            this.requestLayout();
            try {
                CameraPreviewView.this.mCamera.setPreviewDisplay(this.getHolder());
                CameraPreviewView.this.mCamera.startPreview();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"Could not set preview display in surfaceChanged");
            }
            this.handleFocusMetering((float)CameraPreviewView.this.getWidth() / 2.0f, (float)CameraPreviewView.this.getHeight() / 2.0f);
        }

        public void switchCamera() {
            this.initCamera();
        }

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            this.initCamera();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (CameraPreviewView.this.mCamera == null) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            Camera.Size size = CameraPreviewView.this.mCamera.getParameters().getPreviewSize();
            float ratio = 1.0f * (float)size.height / (float)size.width;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = (int)((float)width / ratio);
            int wms = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int hms = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            super.onMeasure(wms, hms);
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (CameraPreviewView.this.mCamera == null) {
                return false;
            }
            if (event.getPointerCount() == 1) {
                switch (event.getAction()) {
                    case 1: {
                        this.handleFocusMetering(event.getX(), event.getY());
                    }
                }
            } else {
                switch (event.getAction() & 0xFF) {
                    case 5: {
                        this.mOldDist = this.getFingerSpacing(event);
                        break;
                    }
                    case 2: {
                        float newDist = this.getFingerSpacing(event);
                        if (newDist > this.mOldDist) {
                            this.handleZoom(true, CameraPreviewView.this.mCamera);
                        } else if (newDist < this.mOldDist) {
                            this.handleZoom(false, CameraPreviewView.this.mCamera);
                        }
                        this.mOldDist = newDist;
                    }
                }
            }
            return true;
        }

        private void handleFocusMetering(float x, float y) {
            Camera.Parameters params = CameraPreviewView.this.mCamera.getParameters();
            Camera.Size previewSize = params.getPreviewSize();
            Rect focusRect = this.calculateTapArea(x, y, 1.0f, previewSize);
            Rect meteringRect = this.calculateTapArea(x, y, 1.5f, previewSize);
            CameraPreviewView.this.mCamera.cancelAutoFocus();
            if (params.getMaxNumFocusAreas() > 0) {
                ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
                focusAreas.add(new Camera.Area(focusRect, 800));
                params.setFocusAreas(focusAreas);
            } else {
                Log.w((String)this.TAG, (String)"focus areas not supported");
            }
            if (params.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 800));
                params.setMeteringAreas(meteringAreas);
            } else {
                Log.w((String)this.TAG, (String)"metering areas not supported");
            }
            final String currentFocusMode = params.getFocusMode();
            CameraHelper.setCameraFocusMode("macro", CameraPreviewView.this.mCamera);
            CameraPreviewView.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    CameraHelper.setCameraFocusMode(currentFocusMode, CameraPreviewView.this.mCamera);
                }
            });
            CameraPreviewView.this.mFocusAnimation.cancel();
            CameraPreviewView.this.mFocusAnimationView.clearAnimation();
            int left = (int)(x - (float)CameraPreviewView.this.mFocusAnimationView.getWidth() / 2.0f);
            int top = (int)(y - (float)CameraPreviewView.this.mFocusAnimationView.getHeight() / 2.0f);
            int right = left + CameraPreviewView.this.mFocusAnimationView.getWidth();
            int bottom = top + CameraPreviewView.this.mFocusAnimationView.getHeight();
            CameraPreviewView.this.mFocusAnimationView.layout(left, top, right, bottom);
            CameraPreviewView.this.mFocusAnimationView.setVisibility(0);
            CameraPreviewView.this.mFocusAnimationView.startAnimation(CameraPreviewView.this.mFocusAnimation);
        }

        private Rect calculateTapArea(float x, float y, float coefficient, Camera.Size previewSize) {
            float focusAreaSize = 300.0f;
            int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
            int centerX = (int)(x / (float)previewSize.width - 1000.0f);
            int centerY = (int)(y / (float)previewSize.height - 1000.0f);
            int left = this.clamp(centerX - areaSize / 2, -1000, 1000);
            int top = this.clamp(centerY - areaSize / 2, -1000, 1000);
            RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
            return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
        }

        private int clamp(int x, int min, int max) {
            if (x > max) {
                return max;
            }
            if (x < min) {
                return min;
            }
            return x;
        }

        private float getFingerSpacing(MotionEvent event) {
            float x = event.getX(0) - event.getX(1);
            float y = event.getY(0) - event.getY(1);
            return (float)Math.sqrt(x * x + y * y);
        }

        private void handleZoom(boolean isZoomIn, Camera camera) {
            Camera.Parameters params = camera.getParameters();
            if (params.isZoomSupported()) {
                int maxZoom = params.getMaxZoom();
                int zoom = params.getZoom();
                if (isZoomIn && zoom < maxZoom) {
                    ++zoom;
                } else if (zoom > 0) {
                    --zoom;
                }
                params.setZoom(zoom);
                camera.setParameters(params);
            } else {
                Log.w((String)this.TAG, (String)"zoom not supported");
            }
        }
    }
}

