/*
 * Decompiled with CFR 0.152.
 */
package com.tsy.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.util.DisplayMetrics;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraHelper {
    private static final String TAG = "CameraHelper";

    public static Camera getCamera(Activity activity, int cameraFacing) throws RuntimeException {
        int cameraId = CameraHelper.getCameraId(cameraFacing);
        Camera camera = Camera.open((int)cameraId);
        CameraHelper.setCameraDisplayOrientation(activity, cameraId, camera);
        return camera;
    }

    private static int setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
        return result;
    }

    private static int getCameraId(int cameraFacing) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != cameraFacing) continue;
            return i;
        }
        return -1;
    }

    public static void setCameraFocusMode(String focusMode, Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List sfm = parameters.getSupportedFocusModes();
        if (sfm.contains(focusMode)) {
            parameters.setFocusMode(focusMode);
        }
        camera.setParameters(parameters);
    }

    public static Camera.Size getFullScreenPreviewSize(Context context, Camera camera) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int w_screen = dm.widthPixels;
        int h_screen = dm.heightPixels;
        Camera.Parameters parameters = camera.getParameters();
        List sizes = parameters.getSupportedPreviewSizes();
        Collections.sort(sizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                return b.width * b.height - a.width * a.height;
            }
        });
        Camera.Size optimalSize = null;
        for (Camera.Size size : sizes) {
            if (size.width != h_screen || size.height != w_screen) continue;
            optimalSize = size;
            break;
        }
        if (optimalSize == null) {
            optimalSize = (Camera.Size)sizes.get(0);
        }
        return optimalSize;
    }
}

