/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;

public class ClassProperties
extends HashMap<String, LinkedList<String>> {
    String platform;
    String platformRoot;
    String pathSeparator;
    LinkedList<Class> inheritedClasses = null;
    LinkedList<Class> effectiveClasses = null;

    public ClassProperties() {
    }

    public ClassProperties(java.util.Properties properties) {
        this.platform = properties.getProperty("platform");
        this.platformRoot = properties.getProperty("platform.root");
        this.pathSeparator = properties.getProperty("platform.path.separator");
        if (this.platformRoot == null || this.platformRoot.length() == 0) {
            this.platformRoot = ".";
        }
        if (!this.platformRoot.endsWith(File.separator)) {
            this.platformRoot = this.platformRoot + File.separator;
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            if (v == null || v.length() == 0) continue;
            if (k.equals("platform.includepath") || k.equals("platform.include") || k.equals("platform.linkpath") || k.equals("platform.link") || k.equals("platform.preloadpath") || k.equals("platform.preload") || k.equals("platform.frameworkpath") || k.equals("platform.framework") || k.equals("platform.library.suffix")) {
                this.addAll(k, v.split(this.pathSeparator));
                continue;
            }
            this.setProperty(k, v);
        }
    }

    public LinkedList<String> get(String key) {
        LinkedList list = (LinkedList)super.get(key);
        if (list == null) {
            list = new LinkedList();
            this.put(key, list);
        }
        return list;
    }

    public void addAll(String key, String ... values) {
        if (values != null) {
            this.addAll(key, Arrays.asList(values));
        }
    }

    public void addAll(String key, Collection<String> values) {
        if (values != null) {
            String root = null;
            if (key.equals("platform.compiler") || key.equals("platform.sysroot") || key.equals("platform.includepath") || key.equals("platform.linkpath")) {
                root = this.platformRoot;
            }
            LinkedList<String> values2 = this.get(key);
            for (String value : values) {
                if (value == null) continue;
                if (root != null && !new File(value).isAbsolute() && new File(root + value).exists()) {
                    value = root + value;
                }
                if (values2.contains(value)) continue;
                values2.add(value);
            }
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        LinkedList<String> values = this.get(key);
        return values.isEmpty() ? defaultValue : values.get(0);
    }

    public String setProperty(String key, String value) {
        LinkedList<String> values = this.get(key);
        String oldValue = values.isEmpty() ? null : values.get(0);
        values.clear();
        this.addAll(key, value);
        return oldValue;
    }

    public void load(Class cls, boolean inherit) {
        Class c = Loader.getEnclosingClass(cls);
        LinkedList classList = new LinkedList();
        classList.addFirst(c);
        while (!c.isAnnotationPresent(Properties.class) && !c.isAnnotationPresent(Platform.class) && c.getSuperclass() != null && c.getSuperclass() != Object.class) {
            c = c.getSuperclass();
            classList.addFirst(c);
        }
        if (this.effectiveClasses == null) {
            this.effectiveClasses = classList;
        }
        Properties classProperties = c.getAnnotation(Properties.class);
        Platform[] platforms = null;
        if (classProperties == null) {
            Platform platform = c.getAnnotation(Platform.class);
            if (platform != null) {
                platforms = new Platform[]{platform};
            }
        } else {
            String helper;
            String target;
            Class[] classes = classProperties.inherit();
            if (inherit && classes != null) {
                if (this.inheritedClasses == null) {
                    this.inheritedClasses = new LinkedList();
                }
                for (Class c2 : classes) {
                    this.load(c2, inherit);
                    if (this.inheritedClasses.contains(c2)) continue;
                    this.inheritedClasses.add(c2);
                }
            }
            if ((target = classProperties.target()).length() > 0) {
                this.addAll("target", target);
            }
            if ((helper = classProperties.helper()).length() > 0) {
                this.addAll("helper", helper);
            }
            platforms = classProperties.value();
        }
        String[] define = new String[]{};
        String[] include = new String[]{};
        String[] cinclude = new String[]{};
        String[] includepath = new String[]{};
        String[] compiler = new String[]{};
        String[] linkpath = new String[]{};
        String[] link = new String[]{};
        String[] frameworkpath = new String[]{};
        String[] framework = new String[]{};
        String[] preloadpath = new String[]{};
        String[] preload = new String[]{};
        String library = "jni" + c.getSimpleName();
        for (Platform p : platforms != null ? platforms : new Platform[]{}) {
            String[][] names = new String[][]{p.value(), p.not()};
            boolean[] matches = new boolean[]{false, false};
            block3: for (int i = 0; i < names.length; ++i) {
                for (String s : names[i]) {
                    if (!this.platform.startsWith(s)) continue;
                    matches[i] = true;
                    continue block3;
                }
            }
            if (names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]) continue;
            if (p.define().length > 0) {
                define = p.define();
            }
            if (p.include().length > 0) {
                include = p.include();
            }
            if (p.cinclude().length > 0) {
                cinclude = p.cinclude();
            }
            if (p.includepath().length > 0) {
                includepath = p.includepath();
            }
            if (p.compiler().length > 0) {
                compiler = p.compiler();
            }
            if (p.linkpath().length > 0) {
                linkpath = p.linkpath();
            }
            if (p.link().length > 0) {
                link = p.link();
            }
            if (p.frameworkpath().length > 0) {
                frameworkpath = p.frameworkpath();
            }
            if (p.framework().length > 0) {
                framework = p.framework();
            }
            if (p.preloadpath().length > 0) {
                preloadpath = p.preloadpath();
            }
            if (p.preload().length > 0) {
                preload = p.preload();
            }
            if (p.library().length() <= 0) continue;
            library = p.library();
        }
        this.addAll("platform.define", define);
        this.addAll("platform.include", include);
        this.addAll("platform.cinclude", cinclude);
        this.addAll("platform.includepath", includepath);
        this.addAll("platform.compiler.*", compiler);
        this.addAll("platform.linkpath", linkpath);
        this.addAll("platform.link", link);
        this.addAll("platform.frameworkpath", frameworkpath);
        this.addAll("platform.framework", framework);
        this.addAll("platform.preloadpath", preloadpath);
        this.addAll("platform.preload", preload);
        this.setProperty("platform.library", library);
    }

    public LinkedList<Class> getInheritedClasses() {
        return this.inheritedClasses;
    }

    public LinkedList<Class> getEffectiveClasses() {
        return this.effectiveClasses;
    }
}

