/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import com.tsmile.easydb.DbTableDefinition;
import com.tsmile.easydb.ObjectConstructor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeAdapter<T> {
    private final ObjectConstructor<T> constructor;
    private final Map<String, BoundField> boundFields;
    private static HashMap<Class, WeakReference<TypeAdapter>> sTypeAdapterCache = new HashMap();

    private TypeAdapter(ObjectConstructor<T> constructor, Map<String, BoundField> boundFields) {
        this.constructor = constructor;
        this.boundFields = boundFields;
    }

    public static <T> TypeAdapter<T> create(Class<? super T> raw) {
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        WeakReference<TypeAdapter> cached = sTypeAdapterCache.get(raw);
        if (cached != null) {
            return (TypeAdapter)cached.get();
        }
        TypeAdapter<? super T> output = new TypeAdapter<T>(TypeAdapter.newDefaultConstructor(raw), TypeAdapter.getBoundFields(raw));
        sTypeAdapterCache.put(raw, new WeakReference<TypeAdapter<? super T>>(output));
        return output;
    }

    public void setToObject(T t, int value, DbTableDefinition.Column column) {
        String key = TypeAdapter.nameToKey(column.fieldName);
        BoundField field = this.boundFields.get(key);
        if (field != null) {
            try {
                if (field.type == Integer.TYPE || field.type == Integer.class) {
                    field.writeField(t, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public T mapToObject(Cursor cursor, List<DbTableDefinition.Column> columns) {
        T instance = this.constructor.construct();
        try {
            for (DbTableDefinition.Column column : columns) {
                int columnIndex;
                String key = TypeAdapter.nameToKey(column.fieldName);
                String columnName = column.columnName;
                BoundField field = this.boundFields.get(key);
                if (field == null || (columnIndex = cursor.getColumnIndex(columnName)) < 0) continue;
                if (field.type == Integer.TYPE || field.type == Integer.class) {
                    field.writeField(instance, cursor.getInt(columnIndex));
                    continue;
                }
                if (field.type == String.class) {
                    field.writeField(instance, cursor.getString(columnIndex));
                    continue;
                }
                if (field.type == Boolean.TYPE || field.type == Boolean.class) {
                    field.writeField(instance, 1 == cursor.getInt(columnIndex));
                    continue;
                }
                if (field.type == Double.TYPE || field.type == Double.class) {
                    field.writeField(instance, cursor.getDouble(columnIndex));
                    continue;
                }
                if (field.type == Long.TYPE || field.type == Long.class) {
                    field.writeField(instance, cursor.getLong(columnIndex));
                    continue;
                }
                if (field.type == Float.TYPE || field.type == Float.class) {
                    field.writeField(instance, Float.valueOf(cursor.getFloat(columnIndex)));
                    continue;
                }
                if (field.type != Short.TYPE && field.type != Short.class) continue;
                field.writeField(instance, cursor.getShort(columnIndex));
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return instance;
    }

    public ContentValues mapToTable(T t, List<DbTableDefinition.Column> columns) {
        ContentValues values = new ContentValues();
        try {
            for (DbTableDefinition.Column column : columns) {
                BoundField field;
                String key = TypeAdapter.nameToKey(column.fieldName);
                if (TextUtils.isEmpty((CharSequence)key) || (field = this.boundFields.get(key)) == null) continue;
                if (field.type == Boolean.TYPE || field.type == Boolean.class) {
                    values.put(column.columnName, Integer.valueOf((Boolean)field.readField(t) != false ? 1 : 0));
                    continue;
                }
                Object fieldValue = field.readField(t);
                if (fieldValue == null) continue;
                values.put(column.columnName, String.valueOf(fieldValue));
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return values;
    }

    private static <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> raw) {
        try {
            final Constructor<T> constructor = raw.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    try {
                        Object[] args = null;
                        return constructor.newInstance(args);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", e.getTargetException());
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static BoundField createBoundField(final Field field) {
        return new BoundField(field.getType()){

            @Override
            void writeField(Object instance, Object value) throws IllegalAccessException {
                field.set(instance, value);
            }

            @Override
            Object readField(Object instance) throws IllegalAccessException {
                return field.get(instance);
            }
        };
    }

    private static Map<String, BoundField> getBoundFields(Class<?> raw) {
        Field[] fields;
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        for (Field field : fields = raw.getDeclaredFields()) {
            field.setAccessible(true);
            BoundField boundField = TypeAdapter.createBoundField(field);
            result.put(TypeAdapter.nameToKey(field.getName()), boundField);
        }
        return result;
    }

    private static String nameToKey(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        return name.replaceAll("_", "").toLowerCase();
    }

    private static abstract class BoundField {
        Type type;

        protected BoundField(Type type) {
            this.type = type;
        }

        abstract void writeField(Object var1, Object var2) throws IllegalAccessException;

        abstract Object readField(Object var1) throws IllegalAccessException;
    }
}

