/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import com.tsmile.easydb.DbUtils;
import java.util.ArrayList;
import java.util.List;

public class DbUpgradeDefinition {
    int fromVersion;
    int toVersion;
    List<String> upgradeSqls;

    private DbUpgradeDefinition(Builder builder) {
        this.fromVersion = builder.fromVersion;
        this.toVersion = builder.toVersion;
        this.upgradeSqls = builder.upgradeSqls;
    }

    public static class Builder {
        private int fromVersion;
        private int toVersion;
        private List<String> upgradeSqls;

        public Builder fromVersion(int fromVersion) {
            this.fromVersion = fromVersion;
            return this;
        }

        public Builder toVersion(int toVersion) {
            this.toVersion = toVersion;
            return this;
        }

        public Builder sql(String[] upgradeSqls) {
            ArrayList<String> listSqls = new ArrayList<String>();
            for (String sql : upgradeSqls) {
                listSqls.add(sql);
            }
            this.upgradeSqls = listSqls;
            return this;
        }

        public Builder sql(String upgradeSql) {
            this.upgradeSqls = DbUtils.splitSqlScript(upgradeSql, ';');
            return this;
        }

        public DbUpgradeDefinition build() {
            return new DbUpgradeDefinition(this);
        }
    }
}

