/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.tsmile.easydb.DbBaseTableModel;
import com.tsmile.easydb.DbDataBase;
import com.tsmile.easydb.DbTableDefinition;
import com.tsmile.easydb.TypeAdapter;
import java.util.ArrayList;
import java.util.List;

public class DbTemplateTableModel<T>
extends DbBaseTableModel {
    protected TypeAdapter<T> typeAdapter;

    public DbTemplateTableModel(DbTableDefinition dbTableDefinition, DbDataBase dbDataBase, Class<? super T> raw) {
        super(dbTableDefinition, dbDataBase);
        this.typeAdapter = TypeAdapter.create(raw);
    }

    public boolean delete(T t) {
        ContentValues primaryValues = this.typeAdapter.mapToTable(t, this.dbTableDefinition.primaryColumns);
        StringBuilder where = new StringBuilder();
        String[] whereArgs = new String[primaryValues.size()];
        DbTemplateTableModel.constructWhere(primaryValues, where, whereArgs);
        return this.delete(where.toString(), whereArgs);
    }

    public boolean update(T t) {
        ContentValues primaryValues = this.typeAdapter.mapToTable(t, this.dbTableDefinition.primaryColumns);
        StringBuilder where = new StringBuilder();
        String[] whereArgs = new String[primaryValues.size()];
        DbTemplateTableModel.constructWhere(primaryValues, where, whereArgs);
        return this.update(this.typeAdapter.mapToTable(t, this.dbTableDefinition.withoutAutoIncrementColumns), where.toString(), whereArgs);
    }

    public boolean bulkUpdate(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return false;
        }
        ContentValues[] valuesArray = new ContentValues[tList.size()];
        String[] whereArray = new String[tList.size()];
        ArrayList<String[]> whereArgsArray = new ArrayList<String[]>(tList.size());
        this.changeUpdateListToContentValues(tList, valuesArray, whereArray, whereArgsArray);
        return this.bulkUpdate(valuesArray, whereArray, whereArgsArray);
    }

    public boolean bulkUpdateInTransaction(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return false;
        }
        ContentValues[] valuesArray = new ContentValues[tList.size()];
        String[] whereArray = new String[tList.size()];
        ArrayList<String[]> whereArgsArray = new ArrayList<String[]>(tList.size());
        this.changeUpdateListToContentValues(tList, valuesArray, whereArray, whereArgsArray);
        return this.bulkUpdateInTransaction(valuesArray, whereArray, whereArgsArray);
    }

    public Integer insert(T t) {
        int rowId = this.insert(this.typeAdapter.mapToTable(t, this.dbTableDefinition.withoutAutoIncrementColumns));
        if (rowId >= 0 && this.dbTableDefinition.autoIncrementColumn != null) {
            this.typeAdapter.setToObject(t, Long.valueOf(rowId).intValue(), this.dbTableDefinition.autoIncrementColumn);
        }
        return rowId;
    }

    public List<Integer> bulkInsert(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return new ArrayList<Integer>();
        }
        return this.bulkInsert(this.changeInsertListToContentValues(tList));
    }

    public List<Integer> bulkInsertInTransaction(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return new ArrayList<Integer>();
        }
        return this.bulkInsertInTransaction(this.changeInsertListToContentValues(tList));
    }

    public List<Integer> clearThenBulkInsert(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return new ArrayList<Integer>();
        }
        return this.clearThenBulkInsert(this.changeInsertListToContentValues(tList));
    }

    public List<Integer> clearThenBulkInsertInTransaction(List<T> tList) {
        if (tList == null || tList.size() == 0) {
            return new ArrayList<Integer>();
        }
        return this.clearThenBulkInsertInTransaction(this.changeInsertListToContentValues(tList));
    }

    private ContentValues[] changeInsertListToContentValues(List<T> tList) {
        ContentValues[] valuesArray = new ContentValues[tList.size()];
        for (int i = 0; i < tList.size(); ++i) {
            valuesArray[i] = this.typeAdapter.mapToTable(tList.get(i), this.dbTableDefinition.withoutAutoIncrementColumns);
        }
        return valuesArray;
    }

    private void changeUpdateListToContentValues(List<T> tList, ContentValues[] valuesArray, String[] whereArray, List<String[]> whereArgsArray) {
        for (int i = 0; i < tList.size(); ++i) {
            T t = tList.get(i);
            ContentValues primaryValues = this.typeAdapter.mapToTable(t, this.dbTableDefinition.primaryColumns);
            StringBuilder where = new StringBuilder();
            String[] whereArgs = new String[primaryValues.size()];
            DbTemplateTableModel.constructWhere(primaryValues, where, whereArgs);
            valuesArray[i] = this.typeAdapter.mapToTable(t, this.dbTableDefinition.withoutAutoIncrementColumns);
            whereArray[i] = where.toString();
            whereArgsArray.add(i, whereArgs);
        }
    }

    public List<T> getAll() {
        return this.get(null, new String[0], null, null, null);
    }

    public List<T> get(String selection, String[] selectionArgs, String orderBy) {
        return this.get(selection, selectionArgs, null, null, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        ArrayList<T> dataList = new ArrayList<T>();
        Cursor cursor = null;
        try {
            this.dbDataBase.readLock().lock();
            SQLiteDatabase db = this.dbDataBase.getReadableDatabase();
            if (db == null) {
                ArrayList<T> arrayList = dataList;
                return arrayList;
            }
            cursor = db.query(this.dbTableDefinition.tableName, null, selection, selectionArgs, groupBy, having, orderBy);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    dataList.add(this.typeAdapter.mapToObject(cursor, this.dbTableDefinition.columns));
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbDataBase.readLock().unlock();
            if (cursor != null) {
                cursor.close();
            }
        }
        return dataList;
    }
}

