/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Environment;
import android.util.Log;

public abstract class DbSQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private Context mContext;
    private final String mFilePath;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;

    public DbSQLiteOpenHelper(String dbPath, String dbName, SQLiteDatabase.CursorFactory factory, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mFilePath = dbPath + dbName;
        this.mFactory = factory;
        this.mNewVersion = version;
    }

    public DbSQLiteOpenHelper(Context context, String dbName, SQLiteDatabase.CursorFactory factory, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        if (context == null) {
            throw new IllegalArgumentException("database with context,context should not be null!");
        }
        this.mContext = context;
        this.mFilePath = dbName;
        this.mFactory = factory;
        this.mNewVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        if (this.mContext == null && !Environment.getExternalStorageState().equals("mounted")) {
            return null;
        }
        boolean success = false;
        SQLiteDatabase db = null;
        try {
            this.mIsInitializing = true;
            db = this.mContext == null ? SQLiteDatabase.openOrCreateDatabase((String)this.mFilePath, (SQLiteDatabase.CursorFactory)this.mFactory) : this.mContext.openOrCreateDatabase(this.mFilePath, 0, this.mFactory);
            if (db == null) {
                SQLiteDatabase sQLiteDatabase = null;
                return sQLiteDatabase;
            }
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                        db.setVersion(this.mNewVersion);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception exception) {}
                }
                this.mDatabase = db;
            } else if (db != null) {
                db.close();
            }
        }
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return null;
        }
        try {
            return this.getWritableDatabase();
        }
        catch (SQLiteException e) {
            if (this.mFilePath == null) {
                throw e;
            }
            Log.e((String)TAG, (String)("Couldn't open " + this.mFilePath + " for writing (will try read-only):"), (Throwable)e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                db = SQLiteDatabase.openDatabase((String)this.mFilePath, (SQLiteDatabase.CursorFactory)this.mFactory, (int)1);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + this.mFilePath);
                }
                this.onOpen(db);
                Log.w((String)TAG, (String)("Opened " + this.mFilePath + " in read-only mode"));
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public abstract void onDowngrade(SQLiteDatabase var1, int var2, int var3);

    public void onOpen(SQLiteDatabase db) {
    }
}

