/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.text.TextUtils;
import com.tsmile.easydb.DbTableDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DbQueryBuilder {
    private final HashMap<String, List<String>> tableColumns = new HashMap();
    private String selection;
    private String orderBy;
    private String groupBy;
    private String having;
    private boolean distinct;

    public DbQueryBuilder tableColumns(String tableName) {
        this.tableColumns.put(tableName, new ArrayList());
        return this;
    }

    public DbQueryBuilder tableColumns(String tableName, List<DbTableDefinition.Column> columns) {
        return this.tableColumns(tableName, columns, "");
    }

    public DbQueryBuilder tableColumns(String tableName, List<DbTableDefinition.Column> columns, String prefix) {
        ArrayList<String> stringColumns = new ArrayList<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            StringBuilder columnNameBuilder = new StringBuilder();
            columnNameBuilder.append(tableName).append(".").append(columns.get((int)i).columnName);
            if (!TextUtils.isEmpty((CharSequence)prefix)) {
                columnNameBuilder.append(" as ").append(prefix).append(columns.get((int)i).columnName);
            }
            stringColumns.set(i, columnNameBuilder.toString());
        }
        this.tableColumns.put(tableName, stringColumns);
        return this;
    }

    public DbQueryBuilder where(String selection) {
        this.selection = selection;
        return this;
    }

    public DbQueryBuilder orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public DbQueryBuilder groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public DbQueryBuilder having(String having) {
        this.having = having;
        return this;
    }

    public DbQueryBuilder distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public String build() {
        if (TextUtils.isEmpty((CharSequence)this.groupBy) && !TextUtils.isEmpty((CharSequence)this.having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (this.tableColumns.size() == 0) {
            throw new IllegalArgumentException("tableColumns not be called");
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (this.distinct) {
            query.append("DISTINCT ");
        }
        StringBuilder columnsBuilder = new StringBuilder();
        Set<String> tables = this.tableColumns.keySet();
        for (String table : tables) {
            List<String> columns = this.tableColumns.get(table);
            if (columns.size() == 0) {
                columnsBuilder = new StringBuilder();
                columnsBuilder.append("* ");
                break;
            }
            DbQueryBuilder.appendColumns(columnsBuilder, columns);
        }
        query.append(columnsBuilder.toString());
        query.append("FROM ");
        DbQueryBuilder.appendColumns(query, tables);
        query.append(tables);
        DbQueryBuilder.appendClause(query, " WHERE ", this.selection);
        DbQueryBuilder.appendClause(query, " GROUP BY ", this.groupBy);
        DbQueryBuilder.appendClause(query, " HAVING ", this.having);
        DbQueryBuilder.appendClause(query, " ORDER BY ", this.orderBy);
        return query.toString();
    }

    public static void appendColumns(StringBuilder s, Collection<String> columns) {
        Iterator<String> iterator = columns.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String column = iterator.next();
            if (column != null) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(column);
            }
            ++i;
        }
        s.append(' ');
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!TextUtils.isEmpty((CharSequence)clause)) {
            s.append(name);
            s.append(clause);
        }
    }
}

