/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import com.tsmile.easydb.DbTableDefinition;
import com.tsmile.easydb.DbUpgradeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbDefinition {
    public int version;
    public String name;
    boolean isUpgradeReCreate;
    public List<DbTableDefinition> dbTableDefinitions;
    Map<Integer, DbUpgradeDefinition> dbUpgradeDefinitions;

    private DbDefinition(Builder builder) {
        this.version = builder.version;
        this.name = builder.name;
        this.dbTableDefinitions = builder.dbTableDefinitions;
        this.isUpgradeReCreate = builder.isUpgradeReCreate;
        this.dbUpgradeDefinitions = this.isUpgradeReCreate ? new HashMap<Integer, DbUpgradeDefinition>() : builder.dbUpgradeDefinitions;
    }

    List<String> getUpgradeSqls(int oldVersion) {
        ArrayList<String> sqls = new ArrayList<String>();
        if (this.isUpgradeReCreate) {
            sqls.addAll(this.getDropSqls());
            sqls.addAll(this.getCreationSqls());
        } else {
            for (int i = oldVersion; i < this.version; ++i) {
                sqls.addAll(this.dbUpgradeDefinitions.get((Object)Integer.valueOf((int)i)).upgradeSqls);
            }
        }
        return sqls;
    }

    List<String> getCreationSqls() {
        ArrayList<String> sqls = new ArrayList<String>();
        for (DbTableDefinition dbTableDefinition : this.dbTableDefinitions) {
            sqls.add(dbTableDefinition.creationSql());
        }
        return sqls;
    }

    List<String> getDropSqls() {
        ArrayList<String> sqls = new ArrayList<String>();
        for (DbTableDefinition dbTableDefinition : this.dbTableDefinitions) {
            sqls.add(dbTableDefinition.dropSql());
        }
        return sqls;
    }

    public static class Builder {
        private int version;
        private String name;
        private boolean isUpgradeReCreate;
        private List<DbTableDefinition> dbTableDefinitions = new ArrayList<DbTableDefinition>();
        private Map<Integer, DbUpgradeDefinition> dbUpgradeDefinitions = new HashMap<Integer, DbUpgradeDefinition>();

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder table(DbTableDefinition dbTableDefinition) {
            this.dbTableDefinitions.add(dbTableDefinition);
            return this;
        }

        public Builder upgrade(DbUpgradeDefinition dbUpgradeDefinition) {
            if (dbUpgradeDefinition.toVersion - dbUpgradeDefinition.fromVersion != 1) {
                throw new IllegalArgumentException("upgrade should like from n to n+1");
            }
            if (this.dbUpgradeDefinitions.get(dbUpgradeDefinition.fromVersion) != null) {
                throw new IllegalArgumentException("already define fromVersion" + dbUpgradeDefinition.fromVersion);
            }
            this.dbUpgradeDefinitions.put(dbUpgradeDefinition.fromVersion, dbUpgradeDefinition);
            return this;
        }

        public Builder setUpgradeReCreate() {
            this.isUpgradeReCreate = true;
            return this;
        }

        public DbDefinition build() {
            return new DbDefinition(this);
        }
    }
}

