/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.tsmile.easydb.DbDefinition;
import com.tsmile.easydb.DbSQLiteOpenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DbDataBase
extends DbSQLiteOpenHelper
implements ReadWriteLock {
    DbDefinition dbDefinition;
    ReadWriteLock readWriteLock;

    public DbDataBase(String dbPath, DbDefinition dbDefinition) {
        super(dbPath, dbDefinition.name, null, dbDefinition.version);
        this.dbDefinition = dbDefinition;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public DbDataBase(Context context, DbDefinition dbDefinition) {
        super(context.getApplicationContext(), dbDefinition.name, null, dbDefinition.version);
        this.dbDefinition = dbDefinition;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public void init() {
        this.getWritableDatabase();
    }

    @Override
    public Lock readLock() {
        return this.readWriteLock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.readWriteLock.writeLock();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        List<String> creationSqls = this.dbDefinition.getCreationSqls();
        for (String sql : creationSqls) {
            db.execSQL(sql);
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.setVersion(newVersion);
        List<String> upgradeSqls = this.dbDefinition.getUpgradeSqls(oldVersion);
        ArrayList<String> createTableNameList = new ArrayList<String>();
        for (String sql : upgradeSqls) {
            if (sql == null) continue;
            if (sql.startsWith("CREATE TABLE ")) {
                int startIndex = "CREATE TABLE ".length();
                int endIndex = sql.indexOf("(");
                if (endIndex > startIndex) {
                    createTableNameList.add(sql.substring(startIndex, endIndex).trim());
                }
                db.execSQL(sql);
                continue;
            }
            boolean alterCreateTable = false;
            if (!createTableNameList.isEmpty()) {
                for (String table : createTableNameList) {
                    if (!sql.contains(table)) continue;
                    alterCreateTable = true;
                    break;
                }
            }
            if (alterCreateTable) {
                try {
                    db.execSQL(sql);
                }
                catch (Throwable e) {
                    Log.w((String)"db-common", (Throwable)e);
                }
                continue;
            }
            db.execSQL(sql);
        }
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public boolean beginTransactionLocked() {
        SQLiteDatabase db = null;
        try {
            this.writeLock().lock();
            db = this.getWritableDatabase();
            db.beginTransaction();
            return true;
        }
        catch (Exception e) {
            if (db != null) {
                try {
                    db.endTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.writeLock().unlock();
            return false;
        }
    }

    public void setTransactionSuccessful() {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.setTransactionSuccessful();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void endTransactionUnlocked() {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.endTransaction();
        }
        catch (Exception exception) {
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

