/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import com.tsmile.easydb.DbDataBase;
import com.tsmile.easydb.DbTableDefinition;
import com.tsmile.easydb.DbTableModel;
import java.util.ArrayList;
import java.util.List;

public abstract class DbBaseTableModel
extends DbTableModel {
    protected final DbTableDefinition dbTableDefinition;

    public DbBaseTableModel(DbTableDefinition dbTableDefinition, DbDataBase dbDataBase) {
        super(dbDataBase);
        this.dbTableDefinition = dbTableDefinition;
    }

    public boolean deleteAll() {
        return this.delete(null, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String whereClause, String[] whereArgs) {
        try {
            this.dbDataBase.writeLock().lock();
            SQLiteDatabase db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                boolean bl = false;
                return bl;
            }
            db.delete(this.dbTableDefinition.tableName, whereClause, whereArgs);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbDataBase.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ContentValues values, String whereClause, String[] whereArgs) {
        try {
            this.dbDataBase.writeLock().lock();
            SQLiteDatabase db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                boolean bl = false;
                return bl;
            }
            db.update(this.dbTableDefinition.tableName, values, whereClause, whereArgs);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbDataBase.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bulkUpdate(ContentValues[] valuesArray, String[] whereClauseArray, List<String[]> whereArgsArray) {
        SQLiteDatabase db = null;
        try {
            int i;
            this.dbDataBase.writeLock().lock();
            db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                boolean bl = false;
                return bl;
            }
            db.beginTransaction();
            for (i = 0; i < valuesArray.length; ++i) {
                db.update(this.dbTableDefinition.tableName, valuesArray[i], whereClauseArray[i], whereArgsArray.get(i));
            }
            db.setTransactionSuccessful();
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                try {
                    db.endTransaction();
                }
                catch (Exception exception) {}
            }
            this.dbDataBase.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(ContentValues values) {
        try {
            this.dbDataBase.writeLock().lock();
            SQLiteDatabase db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                int n = -1;
                return n;
            }
            int n = Long.valueOf(db.insert(this.dbTableDefinition.tableName, null, values)).intValue();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbDataBase.writeLock().unlock();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> bulkInsert(ContentValues[] valuesArray) {
        SQLiteDatabase db = null;
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        try {
            this.dbDataBase.writeLock().lock();
            db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                ArrayList<Integer> arrayList = rowIds;
                return arrayList;
            }
            db.beginTransaction();
            for (ContentValues values : valuesArray) {
                rowIds.add(Long.valueOf(db.insert(this.dbTableDefinition.tableName, null, values)).intValue());
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                try {
                    db.endTransaction();
                }
                catch (Exception exception) {}
            }
            this.dbDataBase.writeLock().unlock();
        }
        return rowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> clearThenBulkInsert(ContentValues[] valuesArray) {
        SQLiteDatabase db = null;
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        try {
            this.dbDataBase.writeLock().lock();
            db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                ArrayList<Integer> arrayList = rowIds;
                return arrayList;
            }
            db.beginTransaction();
            db.delete(this.dbTableDefinition.tableName, null, new String[0]);
            for (ContentValues values : valuesArray) {
                rowIds.add(Long.valueOf(db.insert(this.dbTableDefinition.tableName, null, values)).intValue());
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                try {
                    db.endTransaction();
                }
                catch (Exception exception) {}
            }
            this.dbDataBase.writeLock().unlock();
        }
        return rowIds;
    }

    public boolean bulkUpdateInTransaction(ContentValues[] valuesArray, String[] whereClauseArray, List<String[]> whereArgsArray) {
        SQLiteDatabase db = null;
        try {
            db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                return false;
            }
            for (int i = 0; i < valuesArray.length; ++i) {
                db.update(this.dbTableDefinition.tableName, valuesArray[i], whereClauseArray[i], whereArgsArray.get(i));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Integer> bulkInsertInTransaction(ContentValues[] valuesArray) {
        SQLiteDatabase db = null;
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        try {
            db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                return rowIds;
            }
            for (ContentValues values : valuesArray) {
                rowIds.add(Long.valueOf(db.insert(this.dbTableDefinition.tableName, null, values)).intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowIds;
    }

    public List<Integer> clearThenBulkInsertInTransaction(ContentValues[] valuesArray) {
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        try {
            SQLiteDatabase db = this.dbDataBase.getWritableDatabase();
            if (db == null) {
                return rowIds;
            }
            db.delete(this.dbTableDefinition.tableName, null, new String[0]);
            for (ContentValues values : valuesArray) {
                rowIds.add(Long.valueOf(db.insert(this.dbTableDefinition.tableName, null, values)).intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowIds;
    }
}

