/*
 * Decompiled with CFR 0.152.
 */
package com.tsmile.easydb;

import java.util.ArrayList;
import java.util.List;

public class DbTableDefinition {
    public String tableName;
    public List<Column> columns;
    public List<Column> primaryColumns;
    public Column autoIncrementColumn;
    public List<Column> withoutAutoIncrementColumns;

    private DbTableDefinition(Builder builder) {
        this.tableName = builder.tableName;
        this.primaryColumns = builder.primaryColumns;
        this.autoIncrementColumn = builder.autoIncrementColumn;
        this.withoutAutoIncrementColumns = builder.withoutAutoIncrementColumns;
        this.columns = builder.columns;
    }

    public List<Column> getColumnsWithName(String name) {
        ArrayList<Column> customColumns = new ArrayList<Column>();
        for (Column column : this.columns) {
            if (!name.equals(column.columnName)) continue;
            customColumns.add(column);
            break;
        }
        return customColumns;
    }

    public String creationSql() {
        StringBuilder create = new StringBuilder("CREATE TABLE ");
        create.append(this.tableName).append('(');
        boolean first = true;
        for (Column column : this.columns) {
            if (!first) {
                create.append(',');
            }
            first = false;
            create.append(column.columnName).append(' ').append(column.columnConstraint);
        }
        create.append(')');
        return create.toString();
    }

    public String dropSql() {
        return "DROP TABLE IF EXISTS " + this.tableName;
    }

    public static class Column {
        public String columnName;
        public String columnConstraint;
        public String fieldName;

        public Column(String columnName, String columnConstraint, String fieldName) {
            this.columnName = columnName;
            this.columnConstraint = columnConstraint;
            this.fieldName = fieldName;
        }
    }

    public static class Builder {
        private String tableName;
        private List<Column> columns = new ArrayList<Column>();
        private List<Column> primaryColumns = new ArrayList<Column>();
        private Column autoIncrementColumn;
        private List<Column> withoutAutoIncrementColumns = new ArrayList<Column>();

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        private Builder columnPrimaryAutoIncrement(String name, String constraint, String fieldName) {
            Column column = new Column(name, constraint, fieldName);
            this.columns.add(column);
            this.autoIncrementColumn = column;
            this.primaryColumns.add(column);
            return this;
        }

        private Builder columnPrimary(String name, String constraint, String fieldName) {
            Column column = new Column(name, constraint, fieldName);
            this.columns.add(column);
            this.withoutAutoIncrementColumns.add(column);
            this.primaryColumns.add(column);
            return this;
        }

        private Builder columnNormal(String name, String constraint, String fieldName) {
            Column column = new Column(name, constraint, fieldName);
            this.columns.add(column);
            this.withoutAutoIncrementColumns.add(column);
            return this;
        }

        public Builder realColumnPrimaryKey(String name) {
            return this.columnPrimary(name, "REAL PRIMARY KEY", name);
        }

        public Builder realColumnPrimaryKey(String name, String fieldName) {
            return this.columnPrimary(name, "REAL PRIMARY KEY", fieldName);
        }

        public Builder stringColumnPrimaryKey(String name) {
            return this.columnPrimary(name, "VARCHAR (300) PRIMARY KEY", name);
        }

        public Builder stringColumnPrimaryKey(String name, String fieldName) {
            return this.columnPrimary(name, "VARCHAR (300) PRIMARY KEY", fieldName);
        }

        public Builder intColumnPrimaryKey(String name) {
            return this.columnPrimary(name, "INTEGER PRIMARY KEY", name);
        }

        public Builder intColumnPrimaryKey(String name, String fieldName) {
            return this.columnPrimary(name, "INTEGER PRIMARY KEY", fieldName);
        }

        public Builder intColumnPrimaryKeyAutoIncrement(String name) {
            return this.columnPrimaryAutoIncrement(name, "INTEGER PRIMARY KEY AUTOINCREMENT", name);
        }

        public Builder intColumnPrimaryKeyAutoIncrement(String name, String fieldName) {
            return this.columnPrimaryAutoIncrement(name, "INTEGER PRIMARY KEY AUTOINCREMENT", fieldName);
        }

        public Builder intColumnDefault0(String name) {
            return this.intColumnDefault(name, 0);
        }

        public Builder intColumnDefault0(String name, String fieldName) {
            return this.intColumnDefault(name, 0, fieldName);
        }

        public Builder intColumnDefault(String name, int defaultValue) {
            return this.columnNormal(name, "INTEGER DEFAULT (" + defaultValue + ")", name);
        }

        public Builder intColumnDefault(String name, int defaultValue, String fieldName) {
            return this.columnNormal(name, "INTEGER DEFAULT (" + defaultValue + ")", fieldName);
        }

        public Builder intColumnDefault(String name, String defaultValue) {
            return this.columnNormal(name, "INTEGER DEFAULT (" + defaultValue + ")", name);
        }

        public Builder intColumnDefault(String name, String defaultValue, String fieldName) {
            return this.columnNormal(name, "INTEGER DEFAULT (" + defaultValue + ")", fieldName);
        }

        public Builder intColumn(String name) {
            return this.columnNormal(name, "INTEGER", name);
        }

        public Builder intColumn(String name, String fieldName) {
            return this.columnNormal(name, "INTEGER", fieldName);
        }

        public Builder intColumnNotNull(String name) {
            return this.columnNormal(name, "INTEGER NOT NULL", name);
        }

        public Builder intColumnNotNull(String name, String fieldName) {
            return this.columnNormal(name, "INTEGER NOT NULL", fieldName);
        }

        public Builder realColumn(String name) {
            return this.columnNormal(name, "REAL", name);
        }

        public Builder realColumn(String name, String fieldName) {
            return this.columnNormal(name, "REAL", fieldName);
        }

        public Builder realColumnNotNull(String name) {
            return this.columnNormal(name, "REAL NOT NULL", name);
        }

        public Builder realColumnNotNull(String name, String fieldName) {
            return this.columnNormal(name, "REAL NOT NULL", fieldName);
        }

        public Builder textColumn(String name) {
            return this.columnNormal(name, "TEXT", name);
        }

        public Builder textColumn(String name, String fieldName) {
            return this.columnNormal(name, "TEXT", fieldName);
        }

        public Builder stringColumn(String name, int maxLength) {
            return this.columnNormal(name, "VARCHAR (" + maxLength + ")", name);
        }

        public Builder stringColumn(String name, int maxLength, String fieldName) {
            return this.columnNormal(name, "VARCHAR (" + maxLength + ")", fieldName);
        }

        public Builder stringColumn(String name) {
            return this.columnNormal(name, "VARCHAR (300)", name);
        }

        public Builder stringColumn(String name, String fieldName) {
            return this.columnNormal(name, "VARCHAR (300)", fieldName);
        }

        public DbTableDefinition build() {
            return new DbTableDefinition(this);
        }
    }
}

