/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.listener;

import com.trycath.myupdateapklibrary.listener.ProgressResponseBody;
import com.trycath.myupdateapklibrary.listener.ProgressResponseListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpClientHelper {
    public static OkHttpClient addProgressResponseListener(final ProgressResponseListener progressListener) {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.connectTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS);
        client.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            }
        });
        return client.build();
    }

    public static OkHttpClient getOkhttp() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().connectTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)interceptor).retryOnConnectionFailure(true).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
    }
}

