/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary.dialogactivity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import android.widget.Toast;
import com.trycath.myupdateapklibrary.R;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.service.DownloadFileService;
import com.trycath.myupdateapklibrary.util.FileUtils;
import com.trycath.myupdateapklibrary.util.InstallApk;
import com.trycath.myupdateapklibrary.util.PreferenceUtils;
import com.trycath.myupdateapklibrary.util.StringUtils;
import java.io.Serializable;

public class PromptDialogActivity
extends AppCompatActivity {
    private Button btnNowUpdate;
    private Button btnAfterUpdate;
    private TextView tvTitle;
    private TextView tvVersion;
    private TextView tvSize;
    private TextView tvContent;
    private CheckBox chBox;
    private static String TAG = PromptDialogActivity.class.getSimpleName();
    private static final int REQUEST_EXTERNAL_STORAGE = 111;
    public static final String INTENT_DOWNLOAD_MODEL = "INTENT_DOWNLOAD_MODEL";
    private AppInfoModel appInfoModel;
    private static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    View.OnClickListener nowUpdateListener = new View.OnClickListener(){

        public void onClick(View v) {
            int writePermission = ActivityCompat.checkSelfPermission((Context)PromptDialogActivity.this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            int readPermission = ActivityCompat.checkSelfPermission((Context)PromptDialogActivity.this, (String)"android.permission.READ_EXTERNAL_STORAGE");
            if (writePermission != 0 || readPermission != 0) {
                ActivityCompat.requestPermissions((Activity)PromptDialogActivity.this, (String[])PERMISSIONS_STORAGE, (int)111);
            } else {
                PromptDialogActivity.this.startService();
            }
        }
    };
    View.OnClickListener afterUpdateListener = new View.OnClickListener(){

        public void onClick(View v) {
            PromptDialogActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_prompt_dialog);
        if (this.getIntent() != null && this.getIntent().getExtras() != null && this.getIntent().getExtras().getSerializable(INTENT_DOWNLOAD_MODEL) != null) {
            this.appInfoModel = (AppInfoModel)this.getIntent().getExtras().getSerializable(INTENT_DOWNLOAD_MODEL);
            this.initView();
            this.initContent();
        } else {
            this.finish();
        }
    }

    private void initView() {
        this.btnNowUpdate = (Button)this.findViewById(R.id.btnNowUpdate);
        this.btnAfterUpdate = (Button)this.findViewById(R.id.btnAfterUpdate);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.tvVersion = (TextView)this.findViewById(R.id.tvVersion);
        this.tvSize = (TextView)this.findViewById(R.id.tvSize);
        this.tvContent = (TextView)this.findViewById(R.id.tvContent);
        this.chBox = (CheckBox)this.findViewById(R.id.chBox);
        this.btnNowUpdate.setOnClickListener(this.nowUpdateListener);
        this.btnAfterUpdate.setOnClickListener(this.afterUpdateListener);
        this.chBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    PreferenceUtils.setPrefBoolean((Context)PromptDialogActivity.this, PromptDialogActivity.this.appInfoModel.getVersion(), isChecked);
                }
            }
        });
    }

    private void initContent() {
        this.tvVersion.setText((CharSequence)String.format("%s\uff1a%s", this.getResources().getString(R.string.most_version), this.appInfoModel.getVersionShort()));
        double size = this.appInfoModel.getBinary().getFsize();
        this.tvContent.setText((CharSequence)String.format("%s\n%s", this.getResources().getString(R.string.update_content), this.appInfoModel.getChangelog()));
        if (FileUtils.getFile(this.appInfoModel).exists() && FileUtils.getFileSize(FileUtils.getFile(this.appInfoModel)) == this.appInfoModel.getBinary().getFsize()) {
            this.tvSize.setText((CharSequence)this.getResources().getString(R.string.most_version_downloaded));
        } else {
            this.tvSize.setText((CharSequence)String.format("%s\uff1a%s", this.getResources().getString(R.string.new_version_size), StringUtils.getDataSize(this.appInfoModel.getBinary().getFsize())));
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.d((String)TAG, (String)(requestCode + "===="));
        switch (requestCode) {
            case 111: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startService();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Permission denied to read your External storage", (int)0).show();
                break;
            }
        }
    }

    public static void startActivity(Context context, AppInfoModel appInfoModel) {
        if (appInfoModel != null) {
            Intent intent = new Intent(context, PromptDialogActivity.class);
            intent.putExtra(INTENT_DOWNLOAD_MODEL, (Serializable)appInfoModel);
            context.startActivity(intent);
        }
    }

    public void startService() {
        if (FileUtils.getFile(this.appInfoModel).exists() && FileUtils.getFileSize(FileUtils.getFile(this.appInfoModel)) == this.appInfoModel.getBinary().getFsize()) {
            this.tvSize.setText((CharSequence)this.getResources().getString(R.string.most_version_downloaded));
            InstallApk.startInstall((Context)this, FileUtils.getFile(this.appInfoModel));
            this.finish();
        } else {
            DownloadFileService.startDownloadFileService((Context)this, this.appInfoModel);
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.appInfoModel = (AppInfoModel)savedInstanceState.getSerializable(INTENT_DOWNLOAD_MODEL);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(INTENT_DOWNLOAD_MODEL, (Serializable)this.appInfoModel);
    }
}

