/*
 * Decompiled with CFR 0.152.
 */
package com.trycath.myupdateapklibrary;

import android.content.Context;
import android.util.Log;
import com.trycath.myupdateapklibrary.UpdateKey;
import com.trycath.myupdateapklibrary.dialogactivity.PromptDialogActivity;
import com.trycath.myupdateapklibrary.httprequest.DownloadServiceApi;
import com.trycath.myupdateapklibrary.listener.ServiceGenerator;
import com.trycath.myupdateapklibrary.model.AppInfoModel;
import com.trycath.myupdateapklibrary.util.GetAppInfo;
import com.trycath.myupdateapklibrary.util.IntenetUtil;
import com.trycath.myupdateapklibrary.util.PreferenceUtils;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public class UpdateApk {
    private static final String TAG = "UpdateApk";
    private static volatile UpdateApk sInst = null;
    private static volatile Subscription subscription;
    private static Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateApk init(Context context) {
        UpdateApk inst = sInst;
        if (inst != null) return inst;
        Class<UpdateApk> clazz = UpdateApk.class;
        synchronized (UpdateApk.class) {
            inst = sInst;
            if (inst != null) return inst;
            mContext = context;
            sInst = inst = new UpdateApk(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return inst;
        }
    }

    private UpdateApk(Context context) {
        Log.d((String)TAG, (String)"GETAPPINFO");
        if (UpdateKey.DOWNLOAD_WIFI) {
            switch (IntenetUtil.getNetworkState(mContext)) {
                case 0: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_NONE");
                    break;
                }
                case 2: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_2G");
                    break;
                }
                case 3: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_3G");
                    break;
                }
                case 4: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_4G");
                    break;
                }
                case 5: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_MOBILE");
                    break;
                }
                case 1: {
                    Log.d((String)TAG, (String)"IntenetUtil.NETWORN_WIFI");
                    this.getAppinfo();
                    break;
                }
            }
        } else {
            this.getAppinfo();
        }
    }

    public void getAppinfo() {
        DownloadServiceApi downloadService = ServiceGenerator.createService(DownloadServiceApi.class);
        subscription = downloadService.getUpdateApkInfo(UpdateKey.APP_ID, UpdateKey.API_TOKEN).subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<AppInfoModel>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                Log.d((String)UpdateApk.TAG, (String)e.toString());
            }

            public void onNext(AppInfoModel appInfoModel) {
                Log.d((String)UpdateApk.TAG, (String)appInfoModel.toString());
                UpdateApk.this.valAppInfo(appInfoModel);
            }
        });
    }

    public void valAppInfo(AppInfoModel appInfoModel) {
        if (appInfoModel.getVersion() != null && !PreferenceUtils.getPrefBoolean(mContext, appInfoModel.getVersion(), false)) {
            switch (GetAppInfo.compareVersionCode(GetAppInfo.getVersionCode(mContext), Integer.parseInt(appInfoModel.getVersion()))) {
                case 0: {
                    Log.d((String)TAG, (String)"this is best new version");
                    break;
                }
                case 1: {
                    Log.d((String)TAG, (String)"this is highest version");
                    break;
                }
                case -1: {
                    Log.d((String)TAG, (String)"need update new version");
                    PromptDialogActivity.startActivity(mContext, appInfoModel);
                    break;
                }
            }
        }
    }

    public static void destory() {
        if (sInst != null) {
            sInst = null;
        }
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
            subscription = null;
        }
    }
}

