/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SwipeDismissBehavior;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.trycatch.mysnackbar.AnimationUtils;
import com.trycatch.mysnackbar.Prompt;
import com.trycatch.mysnackbar.R;
import com.trycatch.mysnackbar.ScreenUtil;
import com.trycatch.mysnackbar.SnackbarManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class TSnackbar {
    public static final int APPEAR_FROM_TOP_TO_DOWN = 0;
    public static final int APPEAR_FROM_BOTTOM_TO_TOP = 1;
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    private static final int ANIMATION_DURATION = 250;
    private static final int ANIMATION_FADE_DURATION = 180;
    private static final Handler sHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    ((TSnackbar)message.obj).showView();
                    return true;
                }
                case 1: {
                    ((TSnackbar)message.obj).hideView(message.arg1);
                    return true;
                }
            }
            return false;
        }
    });
    private static final int MSG_SHOW = 0;
    private static final int MSG_DISMISS = 1;
    private int appearDirection = 0;
    private final ViewGroup mParent;
    private final Context mContext;
    private final SnackbarLayout mView;
    private int mDuration;
    private Callback mCallback;
    private final AccessibilityManager mAccessibilityManager;
    private final SnackbarManager.Callback mManagerCallback = new SnackbarManager.Callback(){

        @Override
        public void show() {
            sHandler.sendMessage(sHandler.obtainMessage(0, (Object)TSnackbar.this));
        }

        @Override
        public void dismiss(int event) {
            sHandler.sendMessage(sHandler.obtainMessage(1, event, 0, (Object)TSnackbar.this));
        }
    };

    private TSnackbar(ViewGroup parent) {
        this.appearDirection = 0;
        this.mParent = parent;
        this.mContext = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mView = this.appearDirection == 1 ? (SnackbarLayout)inflater.inflate(R.layout.view_bsnackbar_layout, this.mParent, false) : (SnackbarLayout)inflater.inflate(R.layout.view_tsnackbar_layout, this.mParent, false);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    private TSnackbar(ViewGroup parent, int appearDirection) {
        this.appearDirection = appearDirection;
        this.mParent = parent;
        this.mContext = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mView = appearDirection == 1 ? (SnackbarLayout)inflater.inflate(R.layout.view_bsnackbar_layout, this.mParent, false) : (SnackbarLayout)inflater.inflate(R.layout.view_tsnackbar_layout, this.mParent, false);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (appearDirection == 0) {
            this.setMinHeight(0, 0);
        }
    }

    public TSnackbar setMinHeight(int stateBarHeight, int actionBarHeight) {
        if (this.appearDirection == 0) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (stateBarHeight > 0 || actionBarHeight > 0) {
                    this.mView.setPadding(0, stateBarHeight, 0, 0);
                    this.mView.setMinimumHeight(stateBarHeight + actionBarHeight);
                } else {
                    this.mView.setPadding(0, ScreenUtil.getStatusHeight(this.mContext), 0, 0);
                    this.mView.setMinimumHeight(ScreenUtil.getActionBarHeight(this.mContext) + ScreenUtil.getStatusHeight(this.mContext));
                }
            } else if (stateBarHeight > 0 || actionBarHeight > 0) {
                this.mView.setMinimumHeight(actionBarHeight);
                ScreenUtil.setMargins((View)this.mView, 0, stateBarHeight, 0, 0);
            } else {
                this.mView.setMinimumHeight(ScreenUtil.getActionBarHeight(this.mContext));
                ScreenUtil.setMargins((View)this.mView, 0, ScreenUtil.getStatusHeight(this.mContext), 0, 0);
            }
        }
        return this;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull CharSequence text, int duration) {
        TSnackbar tSnackbar = new TSnackbar(TSnackbar.findSuitableParent(view), 0);
        tSnackbar.setText(text);
        tSnackbar.setDuration(duration);
        return tSnackbar;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull CharSequence text, int duration, int appearDirection) {
        TSnackbar tSnackbar = new TSnackbar(TSnackbar.findSuitableParent(view), appearDirection);
        tSnackbar.setText(text);
        tSnackbar.setDuration(duration);
        return tSnackbar;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @StringRes int resId, int duration) {
        return TSnackbar.make(view, view.getResources().getText(resId), duration);
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    public TSnackbar addIcon(int resource_id) {
        TextView tv = this.mView.getMessageView();
        tv.setCompoundDrawablesWithIntrinsicBounds(this.mContext.getResources().getDrawable(resource_id), null, null, null);
        return this;
    }

    public TSnackbar addIcon(int resource_id, int width, int height) {
        TextView tv = this.mView.getMessageView();
        if (width > 0 || height > 0) {
            tv.setCompoundDrawablesWithIntrinsicBounds((Drawable)new BitmapDrawable(Bitmap.createScaledBitmap((Bitmap)((BitmapDrawable)this.mContext.getResources().getDrawable(resource_id)).getBitmap(), (int)width, (int)height, (boolean)true)), null, null, null);
        } else {
            this.addIcon(resource_id);
        }
        return this;
    }

    public TSnackbar addIconProgressLoading(int resource_id, boolean left, boolean right) {
        Drawable drawable2 = this.mContext.getResources().getDrawable(R.drawable.rotate);
        if (resource_id > 0) {
            drawable2 = this.mContext.getResources().getDrawable(resource_id);
        }
        this.addIconProgressLoading(drawable2, left, right);
        return this;
    }

    public TSnackbar addIconProgressLoading(Drawable drawable2, boolean left, boolean right) {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)drawable2, (String)"level", (int[])new int[]{0, 10000});
        animator.setDuration(1000L);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setRepeatCount(-1);
        animator.setRepeatMode(-1);
        this.mView.setBackgroundColor(this.mContext.getResources().getColor(Prompt.SUCCESS.getBackgroundColor()));
        if (left) {
            this.mView.getMessageView().setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        }
        if (right) {
            this.mView.getMessageView().setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        }
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (TSnackbar.this.mCallback != null) {
                    TSnackbar.this.mCallback.onShown(TSnackbar.this);
                }
                SnackbarManager.getInstance().onShown(TSnackbar.this.mManagerCallback);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
        return this;
    }

    public TSnackbar setPromptThemBackground(Prompt prompt) {
        if (prompt == Prompt.SUCCESS) {
            this.setBackgroundColor(this.mContext.getResources().getColor(Prompt.SUCCESS.getBackgroundColor()));
            this.addIcon(Prompt.SUCCESS.getResIcon(), 0, 0);
        } else if (prompt == Prompt.ERROR) {
            this.setBackgroundColor(this.mContext.getResources().getColor(Prompt.ERROR.getBackgroundColor()));
            this.addIcon(Prompt.ERROR.getResIcon(), 0, 0);
        } else if (prompt == Prompt.WARNING) {
            this.setBackgroundColor(this.mContext.getResources().getColor(Prompt.WARNING.getBackgroundColor()));
            this.addIcon(Prompt.WARNING.getResIcon(), 0, 0);
        }
        return this;
    }

    public TSnackbar setBackgroundColor(int colorId) {
        this.mView.setBackgroundColor(colorId);
        return this;
    }

    @NonNull
    public TSnackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.mContext.getText(resId), listener);
    }

    @NonNull
    public TSnackbar setAction(CharSequence text, final View.OnClickListener listener) {
        Button tv = this.mView.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
        } else {
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    TSnackbar.this.dispatchDismiss(1);
                }
            });
        }
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(ColorStateList colors) {
        Button btn = this.mView.getActionView();
        btn.setTextColor(colors);
        return this;
    }

    @NonNull
    public TSnackbar setActionTextSize(int size) {
        Button btn = this.mView.getActionView();
        btn.setTextSize((float)size);
        return this;
    }

    @NonNull
    public TSnackbar setMessageTextSize(int size) {
        TextView tv = this.mView.getMessageView();
        tv.setTextSize((float)size);
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(@ColorInt int color2) {
        Button btn = this.mView.getActionView();
        btn.setTextColor(color2);
        return this;
    }

    @NonNull
    public TSnackbar setTextColor(@ColorInt int color2) {
        this.setActionTextColor(color2);
        this.setMessageTextColor(color2);
        return this;
    }

    @NonNull
    public TSnackbar setColor(ColorStateList colors) {
        this.setActionTextColor(colors);
        this.setMessageTextColor(colors);
        return this;
    }

    @NonNull
    public TSnackbar setMessageTextColor(@ColorInt int color2) {
        TextView tv = this.mView.getMessageView();
        tv.setTextColor(color2);
        return this;
    }

    @NonNull
    public TSnackbar setMessageTextColor(ColorStateList colors) {
        TextView tv = this.mView.getMessageView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public TSnackbar setText(@NonNull CharSequence message) {
        TextView tv = this.mView.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public TSnackbar setText(@StringRes int resId) {
        return this.setText(this.mContext.getText(resId));
    }

    @NonNull
    public TSnackbar setDuration(int duration) {
        this.mDuration = duration;
        return this;
    }

    public int getDuration() {
        return this.mDuration;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.mDuration, this.mManagerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    private void dispatchDismiss(int event) {
        SnackbarManager.getInstance().dismiss(this.mManagerCallback, event);
    }

    @NonNull
    public TSnackbar setCallback(Callback callback) {
        this.mCallback = callback;
        return this;
    }

    public boolean isShown() {
        return SnackbarManager.getInstance().isCurrent(this.mManagerCallback);
    }

    public boolean isShownOrQueued() {
        return SnackbarManager.getInstance().isCurrentOrNext(this.mManagerCallback);
    }

    final void showView() {
        if (this.mView.getParent() == null) {
            ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior = new Behavior();
                behavior.setStartAlphaSwipeDistance(0.1f);
                behavior.setEndAlphaSwipeDistance(0.6f);
                behavior.setSwipeDirection(0);
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    public void onDismiss(View view) {
                        view.setVisibility(8);
                        TSnackbar.this.dispatchDismiss(0);
                    }

                    public void onDragStateChanged(int state) {
                        switch (state) {
                            case 1: 
                            case 2: {
                                SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                                break;
                            }
                            case 0: {
                                SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                            }
                        }
                    }
                });
                ((CoordinatorLayout.LayoutParams)lp).setBehavior((CoordinatorLayout.Behavior)behavior);
                ((CoordinatorLayout.LayoutParams)lp).setMargins(0, -30, 0, 0);
            }
            this.mParent.addView((View)this.mView);
        }
        if (ViewCompat.isLaidOut((View)this.mView)) {
            this.animateViewIn();
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TSnackbar.this.animateViewIn();
                    TSnackbar.this.mView.setOnLayoutChangeListener(null);
                }
            });
        }
        this.mView.setOnAttachStateChangeListener(new SnackbarLayout.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                if (TSnackbar.this.isShownOrQueued()) {
                    sHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            TSnackbar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)this.mView)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
            } else {
                this.onViewShown();
            }
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TSnackbar.this.mView.setOnLayoutChangeListener(null);
                    if (TSnackbar.this.shouldAnimate()) {
                        TSnackbar.this.animateViewIn();
                    } else {
                        TSnackbar.this.onViewShown();
                    }
                }
            });
        }
    }

    private void animateViewIn() {
        Animation anim2 = this.appearDirection == 0 ? this.getAnimationInFromTopToDown() : this.getAnimationInFromBottomToTop();
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TSnackbar.this.onViewShown();
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    private void animateViewOut(final int event) {
        Animation anim2 = this.appearDirection == 0 ? this.getAnimationOutFromTopToDown() : this.getAnimationOutFromBottomToTop();
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TSnackbar.this.onViewHidden(event);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    private Animation getAnimationInFromTopToDown() {
        return android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_in);
    }

    private Animation getAnimationInFromBottomToTop() {
        return android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_snackbar_in);
    }

    private Animation getAnimationOutFromTopToDown() {
        return android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_out);
    }

    private Animation getAnimationOutFromBottomToTop() {
        return android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_snackbar_out);
    }

    final void hideView(int event) {
        if (this.shouldAnimate() && this.mView.getVisibility() == 0) {
            this.animateViewOut(event);
        } else {
            this.onViewHidden(event);
        }
    }

    private void onViewShown() {
        SnackbarManager.getInstance().onShown(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onShown(this);
        }
    }

    private void onViewHidden(int event) {
        ViewParent parent;
        SnackbarManager.getInstance().onDismissed(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onDismissed(this, event);
        }
        if ((parent = this.mView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.mView);
        }
    }

    private boolean shouldAnimate() {
        return !this.mAccessibilityManager.isEnabled();
    }

    private boolean isBeingDragged() {
        CoordinatorLayout.LayoutParams layoutParams;
        CoordinatorLayout.Behavior behavior;
        ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        if (lp instanceof CoordinatorLayout.LayoutParams && (behavior = (layoutParams = (CoordinatorLayout.LayoutParams)lp).getBehavior()) instanceof SwipeDismissBehavior) {
            return ((SwipeDismissBehavior)behavior).getDragState() != 0;
        }
        return false;
    }

    final class Behavior
    extends SwipeDismissBehavior<SnackbarLayout> {
        Behavior() {
        }

        public boolean canSwipeDismissView(View child) {
            return child instanceof SnackbarLayout;
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, SnackbarLayout child, MotionEvent event) {
            if (parent.isPointInChildBounds((View)child, (int)event.getX(), (int)event.getY())) {
                switch (event.getActionMasked()) {
                    case 0: {
                        SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                        break;
                    }
                    case 1: 
                    case 3: {
                        SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                    }
                }
            }
            return super.onInterceptTouchEvent(parent, (View)child, event);
        }
    }

    public static class SnackbarLayout
    extends LinearLayout {
        private TextView mMessageView;
        private Button mActionView;
        private int mMaxWidth;
        private int mMaxInlineActionWidth;
        private OnLayoutChangeListener mOnLayoutChangeListener;
        private OnAttachStateChangeListener mOnAttachStateChangeListener;

        public SnackbarLayout(Context context) {
            this(context, null);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
            this.mMaxInlineActionWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
            if (a.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, (float)a.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            a.recycle();
            this.setClickable(true);
            LayoutInflater.from((Context)context).inflate(R.layout.view_tsnackbar_layout_include, (ViewGroup)this);
            ViewCompat.setAccessibilityLiveRegion((View)this, (int)1);
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
            this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
        }

        TextView getMessageView() {
            return this.mMessageView;
        }

        Button getActionView() {
            return this.mActionView;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mMaxWidth > 0 && this.getMeasuredWidth() > this.mMaxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            int multiLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
            int singleLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
            boolean isMultiLine = this.mMessageView.getLayout().getLineCount() > 1;
            boolean remeasure = false;
            if (isMultiLine && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
                if (this.updateViewsWithinLayout(1, multiLineVPadding, multiLineVPadding - singleLineVPadding)) {
                    remeasure = true;
                }
            } else {
                int messagePadding;
                int n = messagePadding = isMultiLine ? multiLineVPadding : singleLineVPadding;
                if (this.updateViewsWithinLayout(0, messagePadding, messagePadding)) {
                    remeasure = true;
                }
            }
            if (remeasure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        void animateChildrenIn(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)0.0f);
                ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        void animateChildrenOut(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)1.0f);
                ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (changed && this.mOnLayoutChangeListener != null) {
                this.mOnLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.mOnLayoutChangeListener = onLayoutChangeListener;
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
            this.mOnAttachStateChangeListener = listener;
        }

        private boolean updateViewsWithinLayout(int orientation, int messagePadTop, int messagePadBottom) {
            boolean changed = false;
            if (orientation != this.getOrientation()) {
                this.setOrientation(orientation);
                changed = true;
            }
            if (this.mMessageView.getPaddingTop() != messagePadTop || this.mMessageView.getPaddingBottom() != messagePadBottom) {
                SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, messagePadTop, messagePadBottom);
                changed = true;
            }
            return changed;
        }

        private static void updateTopBottomPadding(View view, int topPadding, int bottomPadding) {
            if (ViewCompat.isPaddingRelative((View)view)) {
                ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)topPadding, (int)ViewCompat.getPaddingEnd((View)view), (int)bottomPadding);
            } else {
                view.setPadding(view.getPaddingLeft(), topPadding, view.getPaddingRight(), bottomPadding);
            }
        }

        static interface OnAttachStateChangeListener {
            public void onViewAttachedToWindow(View var1);

            public void onViewDetachedFromWindow(View var1);
        }

        static interface OnLayoutChangeListener {
            public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OverSnackAppearDirection {
    }

    public static abstract class Callback {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(TSnackbar TSnackbar2, int event) {
        }

        public void onShown(TSnackbar TSnackbar2) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DismissEvent {
        }
    }
}

