/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.app.Activity;
import android.app.ActivityGroup;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;

public class ScreenUtil {
    private static int mStatusHeight = -1;

    private ScreenUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int getStatusHeight(Context context) {
        if (mStatusHeight != -1) {
            return mStatusHeight;
        }
        try {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                mStatusHeight = context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mStatusHeight;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        if (bmp == null) {
            return null;
        }
        Rect frame = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        Bitmap bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)bmp.getWidth(), (int)(bmp.getHeight() - statusBarHeight));
        view.destroyDrawingCache();
        view.setDrawingCacheEnabled(false);
        return bp;
    }

    public static int getActionBarHeight(Context context) {
        int actionBarHeight = 0;
        if (context instanceof AppCompatActivity && ((AppCompatActivity)context).getSupportActionBar() != null) {
            Log.d((String)"isAppCompatActivity", (String)"==AppCompatActivity");
            actionBarHeight = ((AppCompatActivity)context).getSupportActionBar().getHeight();
        } else if (context instanceof Activity && ((Activity)context).getActionBar() != null) {
            Log.d((String)"isActivity", (String)"==Activity");
            actionBarHeight = ((Activity)context).getActionBar().getHeight();
        } else if (context instanceof ActivityGroup) {
            Log.d((String)"ActivityGroup", (String)"==ActivityGroup");
            if (((ActivityGroup)context).getCurrentActivity() instanceof AppCompatActivity && ((AppCompatActivity)((ActivityGroup)context).getCurrentActivity()).getSupportActionBar() != null) {
                actionBarHeight = ((AppCompatActivity)((ActivityGroup)context).getCurrentActivity()).getSupportActionBar().getHeight();
            } else if (((ActivityGroup)context).getCurrentActivity() instanceof Activity && ((ActivityGroup)context).getCurrentActivity().getActionBar() != null) {
                actionBarHeight = ((ActivityGroup)context).getCurrentActivity().getActionBar().getHeight();
            }
        }
        if (actionBarHeight != 0) {
            return actionBarHeight;
        }
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
            if (context.getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
                actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
            }
        } else if (Build.VERSION.SDK_INT >= 11) {
            if (context.getTheme().resolveAttribute(16843499, tv, true)) {
                actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
            }
        } else if (context.getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
            actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        Log.d((String)"actionBarHeight", (String)("====" + actionBarHeight));
        return actionBarHeight;
    }

    public static void setMargins(View v, int l, int t, int r, int b) {
        if (v.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
            p.setMargins(l, t, r, b);
            v.requestLayout();
        }
    }
}

