/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.trycatch.mysnackbar.LUtils;
import com.trycatch.mysnackbar.Prompt;
import com.trycatch.mysnackbar.R;
import com.trycatch.mysnackbar.ScreenUtil;
import com.trycatch.mysnackbar.TSnackBarManager;
import com.trycatch.mysnackbar.TSnackbar;

public class TSnackbarLayout
extends LinearLayout {
    private OnLayoutChangeListener mOnLayoutChangeListener;
    private onViewAlphaChangedListener mOnViewPositionChangedListener;
    private ViewDragHelper mDragHelper;
    private float mDragDismissThreshold = 0.5f;
    private float mAlphaStartSwipeDistance = 0.1f;
    private float mAlphaEndSwipeDistance = 0.8f;
    private static boolean windowTranslucentStatus = false;
    private View container;
    private TextView textView;

    public TSnackbarLayout(Context context) {
        this(context, null);
    }

    public TSnackbarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TSnackbarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new TSnackbarCallBack());
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.container = this.findViewById(R.id.ll_container);
        this.textView = (TextView)this.findViewById(16908308);
        if (windowTranslucentStatus || LUtils.getWindowTranslucentStatus(this.getContext())) {
            windowTranslucentStatus = true;
            this.container.setPadding(0, ScreenUtil.getStatusHeight(this.getContext()), 0, 0);
            return;
        }
        if (TSnackbar.isCoordinatorLayoutFitsSystemWindows()) {
            this.container.setPadding(0, ScreenUtil.getStatusHeight(this.getContext()), 0, 0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.mOnLayoutChangeListener != null) {
            this.mOnLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
        }
    }

    public void setType(Prompt type) {
        if (type == Prompt.SUCCESS) {
            this.textView.setCompoundDrawablesWithIntrinsicBounds(Prompt.SUCCESS.getResIcon(), 0, 0, 0);
            this.container.setBackgroundColor(this.getResources().getColor(Prompt.SUCCESS.getBackgroundColor()));
        } else if (type == Prompt.ERROR) {
            this.textView.setCompoundDrawablesWithIntrinsicBounds(Prompt.ERROR.getResIcon(), 0, 0, 0);
            this.container.setBackgroundColor(this.getResources().getColor(Prompt.ERROR.getBackgroundColor()));
        } else if (type == Prompt.WARNING) {
            this.textView.setCompoundDrawablesWithIntrinsicBounds(Prompt.WARNING.getResIcon(), 0, 0, 0);
            this.container.setBackgroundColor(this.getResources().getColor(Prompt.WARNING.getBackgroundColor()));
        }
    }

    public void setMessage(String message) {
        this.textView.setText((CharSequence)message);
    }

    public void cancelViewDragHelper() {
        if (this.mDragHelper != null) {
            this.mDragHelper.cancel();
            this.mDragHelper = null;
        }
    }

    public void setOnViewPositionChangedListener(onViewAlphaChangedListener onViewPositionChangedListener) {
        this.mOnViewPositionChangedListener = onViewPositionChangedListener;
    }

    void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
        this.mOnLayoutChangeListener = onLayoutChangeListener;
    }

    private void smoothScrollToX(int targetLeft) {
        if (this.mDragHelper != null && this.mDragHelper.settleCapturedViewAt(targetLeft, 0)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void computeScroll() {
        if (this.mDragHelper != null && this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        if (ViewCompat.getAlpha((View)this.container) == 0.0f) {
            TSnackBarManager.instance().clearCurrentSnackbar();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mDragHelper != null && this.mDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDragHelper != null) {
            this.mDragHelper.processTouchEvent(event);
        }
        return true;
    }

    private float fraction(float startValue, float endValue, float value) {
        return (value - startValue) / (endValue - startValue);
    }

    private float clamp(float min, float value, float max) {
        return Math.min(Math.max(min, value), max);
    }

    private class TSnackbarCallBack
    extends ViewDragHelper.Callback {
        private int mOriginalCapturedViewLeft;

        private TSnackbarCallBack() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return TSnackbarLayout.this.container == child;
        }

        public void onViewCaptured(View capturedChild, int activePointerId) {
            this.mOriginalCapturedViewLeft = capturedChild.getLeft();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int targetLeft = this.shouldDismiss(releasedChild, xvel) ? (releasedChild.getLeft() < this.mOriginalCapturedViewLeft ? this.mOriginalCapturedViewLeft - childWidth : this.mOriginalCapturedViewLeft + childWidth) : this.mOriginalCapturedViewLeft;
            TSnackbarLayout.this.smoothScrollToX(targetLeft);
        }

        private boolean shouldDismiss(View child, float xvel) {
            if (xvel != 0.0f) {
                return true;
            }
            int distance = child.getLeft() - this.mOriginalCapturedViewLeft;
            int thresholdDistance = Math.round((float)child.getWidth() * TSnackbarLayout.this.mDragDismissThreshold);
            return Math.abs(distance) >= thresholdDistance;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return left;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            float alpha;
            float startAlphaDistance = (float)this.mOriginalCapturedViewLeft + (float)changedView.getWidth() * TSnackbarLayout.this.mAlphaStartSwipeDistance;
            float endAlphaDistance = (float)this.mOriginalCapturedViewLeft + (float)changedView.getWidth() * TSnackbarLayout.this.mAlphaEndSwipeDistance;
            if ((float)(left = Math.abs(left)) <= startAlphaDistance) {
                alpha = 1.0f;
            } else if ((float)left >= endAlphaDistance) {
                alpha = 0.0f;
            } else {
                float distance = TSnackbarLayout.this.fraction(startAlphaDistance, endAlphaDistance, left);
                alpha = TSnackbarLayout.this.clamp(0.0f, 1.0f - distance, 1.0f);
            }
            ViewCompat.setAlpha((View)changedView, (float)alpha);
            if (TSnackbarLayout.this.mOnViewPositionChangedListener != null && LUtils.hasL()) {
                TSnackbarLayout.this.mOnViewPositionChangedListener.onViewAlphaChanged(1.0f - alpha);
            }
        }

        public void onViewDragStateChanged(int state) {
            switch (state) {
                case 1: 
                case 2: {
                    TSnackBarManager.instance().cancelTimeout();
                    break;
                }
                case 0: {
                    TSnackBarManager.instance().restoreTimeout();
                }
            }
        }
    }

    static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
    }

    static interface onViewAlphaChangedListener {
        public void onViewAlphaChanged(float var1);
    }
}

