/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.trycatch.mysnackbar.LUtils;
import com.trycatch.mysnackbar.Prompt;
import com.trycatch.mysnackbar.R;
import com.trycatch.mysnackbar.TSnackBarManager;
import com.trycatch.mysnackbar.TSnackbarLayout;

public class TSnackbar
implements TSnackbarLayout.onViewAlphaChangedListener {
    private ViewGroup mParent;
    private TSnackbarLayout mView;
    private static boolean coordinatorLayoutFitSystemWindows = false;
    public static final int LENGTH_INDEFINITE = -1;
    public static final int LENGTH_SHORT = -2;
    public static final int LENGTH_LONG = -3;
    public static final int ANIMATION_DURATION = 250;
    private static int SnackBar_layoutResID = R.layout.tsnackbar_view;
    private static int mColorPrimaryDark = -1;
    private static int endA;
    private static int endR;
    private static int endG;
    private static int endB;
    private int mDuration = -2;
    private LUtils lUtils;
    int startColor;
    int startA;
    int startR;
    int startG;
    int startB;

    private TSnackbar(ViewGroup parent, String message, Prompt type) {
        if (parent != null) {
            this.mParent = parent;
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            this.mView = (TSnackbarLayout)inflater.inflate(SnackBar_layoutResID, this.mParent, false);
            this.setPrompt(type);
            this.mView.setType(type);
            this.mView.setMessage(message);
            this.mView.setOnViewPositionChangedListener(this);
            if (mColorPrimaryDark == -1) {
                mColorPrimaryDark = LUtils.getDefaultStatusBarBackground(parent.getContext());
                endA = mColorPrimaryDark >> 24 & 0xFF;
                endR = mColorPrimaryDark >> 16 & 0xFF;
                endG = mColorPrimaryDark >> 8 & 0xFF;
                endB = mColorPrimaryDark & 0xFF;
            }
        } else {
            this.mView = null;
        }
    }

    public static void setColorPrimaryDark(int mColorPrimaryDark) {
        TSnackbar.mColorPrimaryDark = mColorPrimaryDark;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull String message, @NonNull Prompt prompt) {
        return TSnackbar.make(view, message, prompt, -2);
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull String message, @NonNull Prompt prompt, int duration) {
        TSnackbar snackbar = new TSnackbar(TSnackbar.findSuitableParent(view), message, prompt);
        snackbar.setDuration(duration);
        return snackbar;
    }

    @NonNull
    public TSnackbar setAction(final View.OnClickListener listener) {
        TextView tv = (TextView)this.mView.findViewById(16908308);
        tv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick(view);
                TSnackbar.this.dismissView();
            }
        });
        return this;
    }

    public static void setCoordinatorLayoutFitsSystemWindows(boolean coordinatorLayoutFitSystemWindows) {
        TSnackbar.coordinatorLayoutFitSystemWindows = coordinatorLayoutFitSystemWindows;
    }

    public static boolean isCoordinatorLayoutFitsSystemWindows() {
        return coordinatorLayoutFitSystemWindows;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        if (this.mDuration == -1 && this.mView != null) {
            this.mView.cancelViewDragHelper();
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    public void show() {
        if (this.mView != null && this.mView.getContext() instanceof Activity) {
            this.lUtils = LUtils.instance((Activity)this.mView.getContext());
        }
        TSnackBarManager.instance().show(this.mDuration, this);
    }

    public static void setSnackBar_layoutResID(int snackBar_layoutResID) {
        SnackBar_layoutResID = snackBar_layoutResID;
    }

    public void setPrompt(Prompt prompt) {
        if (this.mView == null) {
            return;
        }
        this.startColor = this.mView.getContext().getResources().getColor(prompt.getBackgroundColor());
        this.startA = this.startColor >> 24 & 0xFF;
        this.startR = this.startColor >> 16 & 0xFF;
        this.startG = this.startColor >> 8 & 0xFF;
        this.startB = this.startColor & 0xFF;
    }

    public void showView() {
        if (this.mView == null || this.mParent == null) {
            return;
        }
        if (this.mView.getParent() == null) {
            this.mParent.addView((View)this.mView);
        }
        if (ViewCompat.isLaidOut((View)this.mView)) {
            this.animateViewIn();
        } else {
            this.mView.setOnLayoutChangeListener(new TSnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TSnackbar.this.animateViewIn();
                    TSnackbar.this.mView.setOnLayoutChangeListener(null);
                }
            });
        }
    }

    private void animateViewIn() {
        if (this.mView == null) {
            return;
        }
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_in);
        anim2.setDuration(250L);
        anim2.setInterpolator((Interpolator)new FastOutSlowInInterpolator());
        this.mView.startAnimation(anim2);
        this.animateStatusBarColor(true);
    }

    public void dismissView() {
        this.animateViewOut();
    }

    private void animateViewOut() {
        if (this.mView == null) {
            return;
        }
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_out);
        anim2.setDuration(250L);
        anim2.setInterpolator((Interpolator)new FastOutSlowInInterpolator());
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TSnackbar.this.clearView();
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.animateStatusBarColor(false);
        this.mView.startAnimation(anim2);
    }

    private void animateStatusBarColor(boolean animateViewIn) {
        if (this.lUtils == null || !LUtils.hasL() || this.mDuration == -1) {
            return;
        }
        if (animateViewIn) {
            this.lUtils.setStatusBarColor(this.startColor);
        } else {
            ObjectAnimator mStatusBarColorAnimator = ObjectAnimator.ofInt((Object)this.lUtils, (String)"statusBarColor", (int[])new int[]{this.lUtils.getStatusBarColor(), mColorPrimaryDark}).setDuration(250L);
            mStatusBarColorAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            mStatusBarColorAnimator.start();
        }
    }

    @Override
    public void onViewAlphaChanged(float fraction) {
        int color2 = this.startA + (int)(fraction * (float)(endA - this.startA)) << 24 | this.startR + (int)(fraction * (float)(endR - this.startR)) << 16 | this.startG + (int)(fraction * (float)(endG - this.startG)) << 8 | this.startB + (int)(fraction * (float)(endB - this.startB));
        if (this.lUtils != null) {
            this.lUtils.setStatusBarColor(color2);
        }
    }

    public void clearView() {
        if (this.mParent != null) {
            this.mParent.removeView((View)this.mView);
            this.mView = null;
            this.mParent = null;
        }
    }

    public TSnackbarLayout getView() {
        return this.mView;
    }
}

