/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.trycatch.mysnackbar.TSnackbar;

public class TSnackBarManager {
    private static volatile TSnackBarManager instance;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            TSnackBarManager.this.dismissView();
            return true;
        }
    });
    TSnackbar mCurrentSnackBar;
    private static final int MSG_TIMEOUT = 0;
    public static final int LENGTH_SHORT = 1500;
    public static final int LENGTH_LONG = 2750;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TSnackBarManager instance() {
        if (instance != null) return instance;
        Class<TSnackBarManager> clazz = TSnackBarManager.class;
        synchronized (TSnackBarManager.class) {
            if (instance != null) return instance;
            instance = new TSnackBarManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TSnackBarManager() {
    }

    public void show(int duration, TSnackbar nextSnackBar) {
        if (nextSnackBar == null) {
            return;
        }
        this.cancelTimeout();
        if (this.mCurrentSnackBar != null) {
            this.mCurrentSnackBar.clearView();
            this.mCurrentSnackBar = null;
        }
        nextSnackBar.showView();
        if (duration != -1) {
            this.mCurrentSnackBar = nextSnackBar;
            this.scheduleTimeout(duration);
        }
    }

    private void dismissView() {
        if (this.mCurrentSnackBar != null) {
            this.mCurrentSnackBar.dismissView();
        }
    }

    public void clearCurrentSnackbar() {
        if (this.mCurrentSnackBar != null) {
            this.mCurrentSnackBar.clearView();
            this.mCurrentSnackBar = null;
        }
    }

    public void scheduleTimeout(int duration) {
        int handlerDuration = 250;
        handlerDuration = duration == -2 ? (handlerDuration += 1500) : (duration == -3 ? (handlerDuration += 2750) : (handlerDuration += duration));
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0), (long)handlerDuration);
    }

    public void cancelTimeout() {
        this.mHandler.removeMessages(0);
    }

    public void restoreTimeout() {
        if (this.mCurrentSnackBar != null) {
            this.scheduleTimeout(this.mCurrentSnackBar.getDuration());
        }
    }
}

