/*
 * Decompiled with CFR 0.152.
 */
package com.trycatch.mysnackbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.trycatch.mysnackbar.ScreenUtil;
import com.trycatch.mysnackbar.TSnackbar;

@TargetApi(value=21)
public class LUtils {
    protected Activity mActivity;
    private static volatile LUtils instance;
    private static final int[] THEME_ATTRS;

    private LUtils(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static LUtils instance(Activity activity) {
        if (instance == null) {
            Class<LUtils> clazz = LUtils.class;
            // MONITORENTER : com.trycatch.mysnackbar.LUtils.class
            if (instance == null) {
                instance = new LUtils(activity);
            }
            // MONITOREXIT : clazz
        }
        instance.setActivity(activity);
        return instance;
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public static void clear() {
        LUtils.resetColorPrimaryDark();
        if (instance != null) {
            LUtils.instance.mActivity = null;
            instance = null;
        }
    }

    public static boolean hasL() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean hasKitKat() {
        return Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21;
    }

    public static boolean belowKitKat() {
        return Build.VERSION.SDK_INT < 19;
    }

    public int getStatusBarColor() {
        Drawable drawable;
        ViewGroup contentView;
        View statusBarView;
        if (LUtils.belowKitKat()) {
            return -16777216;
        }
        if (LUtils.hasL()) {
            return this.mActivity.getWindow().getStatusBarColor();
        }
        if (LUtils.hasKitKat() && (statusBarView = (contentView = (ViewGroup)this.mActivity.findViewById(0x1020002)).getChildAt(0)) != null && statusBarView.getMeasuredHeight() == ScreenUtil.getStatusHeight((Context)this.mActivity) && (drawable = statusBarView.getBackground()) != null) {
            return ((ColorDrawable)drawable).getColor();
        }
        return -1;
    }

    public void setStatusBarColor(int color) {
        if (LUtils.belowKitKat()) {
            return;
        }
        if (LUtils.hasL()) {
            this.mActivity.getWindow().setStatusBarColor(color);
            return;
        }
        if (LUtils.hasKitKat()) {
            ViewGroup contentView = (ViewGroup)this.mActivity.findViewById(0x1020002);
            View statusBarView = contentView.getChildAt(0);
            if (statusBarView != null && statusBarView.getMeasuredHeight() == ScreenUtil.getStatusHeight((Context)this.mActivity)) {
                statusBarView.setBackgroundColor(color);
                return;
            }
            statusBarView = new View((Context)this.mActivity);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, ScreenUtil.getStatusHeight((Context)this.mActivity));
            statusBarView.setBackgroundColor(color);
            contentView.addView(statusBarView, 0, lp);
        }
    }

    public static int getDefaultStatusBarBackground(Context context) {
        TypedArray a = context.obtainStyledAttributes(THEME_ATTRS);
        try {
            int n = a.getColor(0, 0);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static boolean getWindowTranslucentStatus(Context context) {
        TypedArray a = context.obtainStyledAttributes(THEME_ATTRS);
        try {
            boolean bl = a.getBoolean(1, false);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static void resetColorPrimaryDark() {
        TSnackbar.setColorPrimaryDark(-1);
    }

    static {
        THEME_ATTRS = new int[]{16843828, 16843759};
    }
}

