/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonEnvironment.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neonEnvironment.model.LatLong;
import com.trx.neon.api.neonEnvironment.model.NeonFloorOutline;
import java.util.ArrayList;

public class NeonBuildingFloor
implements Parcelable {
    private final int FloorNumber;
    private final String Label;
    private final NeonFloorOutline Outline;
    private final ArrayList<LatLong> FloorPlanCorners;
    private final String FloorPlanImageID;
    public static final Parcelable.Creator<NeonBuildingFloor> CREATOR = new Parcelable.Creator<NeonBuildingFloor>(){

        public NeonBuildingFloor createFromParcel(Parcel in) {
            return new NeonBuildingFloor(in);
        }

        public NeonBuildingFloor[] newArray(int size) {
            return new NeonBuildingFloor[size];
        }
    };

    public NeonBuildingFloor(int floorNumber, String label, NeonFloorOutline outline, ArrayList<LatLong> floorPlanCorners, String floorPlanImageID) {
        this.FloorNumber = floorNumber;
        this.Label = label;
        this.Outline = new NeonFloorOutline(outline);
        this.FloorPlanCorners = floorPlanCorners;
        this.FloorPlanImageID = floorPlanImageID;
    }

    public int getFloorNumber() {
        return this.FloorNumber;
    }

    public String getLabel() {
        return this.Label;
    }

    public NeonFloorOutline getOutline() {
        return this.Outline;
    }

    public String getFloorPlanImageID() {
        return this.FloorPlanImageID;
    }

    public ArrayList<LatLong> getFloorPlanCorners() {
        return this.FloorPlanCorners;
    }

    public boolean hasFloorPlan() {
        return this.FloorPlanImageID != null;
    }

    private NeonBuildingFloor(Parcel in) {
        this.FloorNumber = in.readInt();
        this.Label = in.readString();
        this.Outline = new NeonFloorOutline(in);
        this.FloorPlanCorners = new ArrayList();
        in.readTypedList(this.FloorPlanCorners, LatLong.CREATOR);
        this.FloorPlanImageID = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.FloorNumber);
        dest.writeString(this.Label);
        this.Outline.writeToParcel(dest, flags);
        dest.writeTypedList(this.FloorPlanCorners);
        dest.writeString(this.FloorPlanImageID);
    }
}

