/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonEnvironment.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neonEnvironment.model.NeonBuildingFloor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class NeonBuilding
implements Parcelable {
    private final UUID ID;
    private final String Name;
    private final ArrayList<NeonBuildingFloor> Floors;
    private final HashMap<Integer, Integer> floorMap;
    public static final Parcelable.Creator<NeonBuilding> CREATOR = new Parcelable.Creator<NeonBuilding>(){

        public NeonBuilding createFromParcel(Parcel in) {
            return new NeonBuilding(in);
        }

        public NeonBuilding[] newArray(int size) {
            return new NeonBuilding[size];
        }
    };

    public NeonBuilding(UUID id, String name, ArrayList<NeonBuildingFloor> floors) {
        this.ID = id;
        this.Name = name;
        this.Floors = new ArrayList<NeonBuildingFloor>(floors);
        int i = 0;
        this.floorMap = new HashMap();
        for (NeonBuildingFloor bf : this.Floors) {
            this.floorMap.put(bf.getFloorNumber(), i++);
        }
    }

    public UUID getID() {
        return this.ID;
    }

    public String getName() {
        if (this.Name == null) {
            return this.ID.toString().substring(0, 8);
        }
        return this.Name;
    }

    public ArrayList<NeonBuildingFloor> getFloors() {
        return new ArrayList<NeonBuildingFloor>(this.Floors);
    }

    public NeonBuildingFloor getFloor(int floorNumber) {
        Integer mapKey = this.floorMap.get(floorNumber);
        if (mapKey == null) {
            return null;
        }
        return this.Floors.get(mapKey);
    }

    private NeonBuilding(Parcel in) {
        this.ID = UUID.fromString(in.readString());
        this.Name = in.readString();
        this.Floors = in.createTypedArrayList(NeonBuildingFloor.CREATOR);
        int i = 0;
        this.floorMap = new HashMap();
        for (NeonBuildingFloor bf : this.Floors) {
            this.floorMap.put(bf.getFloorNumber(), i++);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.ID.toString());
        dest.writeString(this.Name);
        dest.writeTypedList(this.Floors);
    }
}

