/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class GPSConstraint
implements Parcelable {
    private final long timestamp;
    public final double Latitude;
    public final double Longitude;
    public final float LocationError;
    public final boolean Broadcast;
    public static final Parcelable.Creator<GPSConstraint> CREATOR = new Parcelable.Creator<GPSConstraint>(){

        public GPSConstraint createFromParcel(Parcel in) {
            return new GPSConstraint(in);
        }

        public GPSConstraint[] newArray(int size) {
            return new GPSConstraint[size];
        }
    };

    public GPSConstraint(long unixTimeMs, double latitude, double longitude, float locationError) {
        this(unixTimeMs, latitude, longitude, locationError, false);
    }

    public GPSConstraint(long unixTimeMs, double latitude, double longitude, float locationError, boolean broadcast) {
        this.timestamp = SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.LocationError = locationError;
        this.Broadcast = broadcast;
    }

    public long getTimeUTCMillis() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime() + this.timestamp;
    }

    public long getElapsedRealtimeMillis() {
        return this.timestamp;
    }

    private GPSConstraint(Parcel in) {
        this.timestamp = in.readLong();
        this.Latitude = in.readDouble();
        this.Longitude = in.readDouble();
        this.LocationError = in.readFloat();
        this.Broadcast = in.readByte() > 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeDouble(this.Latitude);
        dest.writeDouble(this.Longitude);
        dest.writeFloat(this.LocationError);
        dest.writeByte(this.Broadcast ? (byte)1 : 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GPS Constraint: ");
        sb.append("Time: ");
        sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(this.getTimeUTCMillis())));
        sb.append(" Location: (" + this.Latitude + ", " + this.Longitude + ")");
        sb.append(" Location Error: " + this.LocationError + " m");
        sb.append(" Broadcast: " + this.Broadcast);
        return sb.toString();
    }
}

