/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.UUID;

public class ElevationInfo
implements Parcelable {
    public final ElevationType Type;
    public final UUID StructureID;
    public final double Value;
    public static final Parcelable.Creator<ElevationInfo> CREATOR = new Parcelable.Creator<ElevationInfo>(){

        public ElevationInfo createFromParcel(Parcel in) {
            return new ElevationInfo(in);
        }

        public ElevationInfo[] newArray(int size) {
            return new ElevationInfo[size];
        }
    };

    private ElevationInfo(ElevationType type, double value, UUID structureID) {
        this.Type = type;
        this.Value = value;
        this.StructureID = structureID;
    }

    public static ElevationInfo OnFloor(int floor) {
        return new ElevationInfo(ElevationType.Floor, floor, null);
    }

    public static ElevationInfo OnFloor(UUID structureID, int floor) {
        return new ElevationInfo(ElevationType.BuildingFloor, floor, structureID);
    }

    public static ElevationInfo OnTerrain() {
        return new ElevationInfo(ElevationType.OnTerrain, 0.0, null);
    }

    public static ElevationInfo AtAltitude(float altitude) {
        return new ElevationInfo(ElevationType.Altitude, altitude, null);
    }

    public static ElevationInfo None() {
        return new ElevationInfo(ElevationType.None, 0.0, null);
    }

    ElevationInfo(Parcel in) {
        int valueIndex = in.readInt();
        if (valueIndex < ElevationType.values().length) {
            this.Type = ElevationType.values()[in.readInt()];
            this.Value = in.readDouble();
            if (this.Type == ElevationType.BuildingFloor) {
                long mostSig = in.readLong();
                long leastSig = in.readLong();
                this.StructureID = new UUID(mostSig, leastSig);
            } else {
                this.StructureID = null;
            }
        } else {
            this.Type = ElevationType.None;
            this.Value = 0.0;
            this.StructureID = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.Type.ordinal());
        dest.writeDouble(this.Value);
        if (this.Type == ElevationType.BuildingFloor) {
            long mostSig = this.StructureID.getMostSignificantBits();
            long leastSig = this.StructureID.getLeastSignificantBits();
            dest.writeLong(mostSig);
            dest.writeLong(leastSig);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Type.toString());
        if (this.Type == ElevationType.Floor || this.Type == ElevationType.UndergroundFloor) {
            sb.append(": ");
            sb.append(this.Value);
        } else if (this.Type == ElevationType.Altitude) {
            sb.append(": ");
            sb.append(this.Value);
            sb.append(" m");
        } else if (this.Type == ElevationType.BuildingFloor) {
            sb.append(": ");
            sb.append(this.Value);
            sb.append(" (" + this.StructureID + ")");
        }
        return sb.toString();
    }

    public static enum ElevationType {
        None,
        Floor,
        OnTerrain,
        Altitude,
        Underground,
        UndergroundFloor,
        BuildingFloor;

    }
}

