/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class SafetyAlertEvent
implements Parcelable,
INeonEvent {
    public final long startTimeMs;
    public final long endTimeMs;
    private final String type;
    public static final Parcelable.Creator<SafetyAlertEvent> CREATOR = new Parcelable.Creator<SafetyAlertEvent>(){

        public SafetyAlertEvent createFromParcel(Parcel in) {
            return new SafetyAlertEvent(in);
        }

        public SafetyAlertEvent[] newArray(int size) {
            return new SafetyAlertEvent[size];
        }
    };

    public SafetyAlertEventType getType() {
        try {
            return Enum.valueOf(SafetyAlertEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getKey() {
        return NeonEventType.SAFETY_ALERT.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.SAFETY_ALERT;
    }

    public SafetyAlertEvent(long startTimeMs, long endTimeMs, SafetyAlertEventType eventType) {
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.type = eventType.name();
    }

    private SafetyAlertEvent(Parcel in) {
        this.startTimeMs = in.readLong();
        this.endTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.startTimeMs);
        dest.writeLong(this.endTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Start: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.startTimeMs)) + ", " + "End: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.endTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum SafetyAlertEventType {
        NO_MOTION,
        HIGH_IMPACT,
        FREE_FALL;

    }
}

