/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class ConnectivityEvent
implements Parcelable,
INeonEvent {
    private final long unixTimeMs;
    private final String type;
    public final boolean connected;
    public static final Parcelable.Creator<ConnectivityEvent> CREATOR = new Parcelable.Creator<ConnectivityEvent>(){

        public ConnectivityEvent createFromParcel(Parcel in) {
            return new ConnectivityEvent(in);
        }

        public ConnectivityEvent[] newArray(int size) {
            return new ConnectivityEvent[size];
        }
    };

    public ConnectivityEventType getType() {
        try {
            return Enum.valueOf(ConnectivityEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getKey() {
        return this.type;
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.CONNECTIVITY;
    }

    public ConnectivityEvent(long unixTimeMs, ConnectivityEventType type, boolean connected) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
        this.connected = connected;
    }

    private ConnectivityEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
        this.connected = in.readByte() > 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
        dest.writeByte(this.connected ? (byte)1 : 0);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type + ", " + "Connected: " + this.connected;
    }

    public static enum ConnectivityEventType {
        SERVER,
        SENSORS;

    }
}

