/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class AuthenticationEvent
implements Parcelable,
INeonEvent {
    private final long unixTimeMs;
    private final String type;
    public static final Parcelable.Creator<AuthenticationEvent> CREATOR = new Parcelable.Creator<AuthenticationEvent>(){

        public AuthenticationEvent createFromParcel(Parcel in) {
            return new AuthenticationEvent(in);
        }

        public AuthenticationEvent[] newArray(int size) {
            return new AuthenticationEvent[size];
        }
    };

    public AuthenticationEventType getType() {
        try {
            return Enum.valueOf(AuthenticationEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getKey() {
        return this.type;
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.AUTHENTICATION;
    }

    public AuthenticationEvent(long unixTimeMs, AuthenticationEventType type) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
    }

    private AuthenticationEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum AuthenticationEventType {
        NO_CREDENTIALS_SET,
        MANDATORY_UPDATE_REQUIRED,
        UNRESOLVED_AUTHENTICATION_ERROR,
        NO_INTERNET,
        SUCCESS;

    }
}

