/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api._internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.trx.neon.api._internal.legacy.MapperStructuralFeatureEvent;
import com.trx.neon.api._internal.legacy.NavResetEvent;
import com.trx.neon.api._internal.legacy.SessionEventLegacy;
import com.trx.neon.api._internal.legacy.StructuralFeatureEvent;
import com.trx.neon.api.neon.model.NeonLocation;
import com.trx.neon.api.neon.model.events.AuthenticationEvent;
import com.trx.neon.api.neon.model.events.BatteryEvent;
import com.trx.neon.api.neon.model.events.BindingEvent;
import com.trx.neon.api.neon.model.events.ConnectivityEvent;
import com.trx.neon.api.neon.model.events.MotionLevelEvent;
import com.trx.neon.api.neon.model.events.NavLockEvent;
import com.trx.neon.api.neon.model.events.PostureEvent;
import com.trx.neon.api.neon.model.events.SafetyAlertEvent;
import com.trx.neon.api.neon.model.events.SessionEvent;
import com.trx.neon.api.neon.model.events.UpdateAvailableEvent;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.interfaces.INeonEventListener;
import com.trx.neon.api.neon.model.interfaces.INeonLocationListener;
import com.trx.neon.api.neon.model.types.NeonEventType;
import com.trx.neon.api.neon.model.types.NeonLocationType;
import com.trx.neon.api.neonBeta.model.DebugLocation;
import com.trx.neon.api.neonBeta.model.GPSConstraint;
import com.trx.neon.api.neonBeta.model.LineSegmentConstraint;
import com.trx.neon.api.neonBeta.model.ManualConstraint;
import com.trx.neon.api.neonBeta.model.NeonInertialDelta;
import com.trx.neon.api.neonBeta.model.RangingConstraint;
import com.trx.neon.api.neonBeta.model.events.CalibrationEvent;
import com.trx.neon.api.neonBeta.model.events.NewFloorEvent;
import com.trx.neon.api.neonBeta.model.events.RemoteRangeEvent;
import com.trx.neon.api.neonBeta.model.events.UserActivityEvent;
import com.trx.neon.api.neonBeta.model.events.VehicleStateEvent;
import com.trx.neon.api.neonBeta.model.events.WarfighterEvent;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventBeta;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventListenerBeta;
import com.trx.neon.api.neonBeta.model.types.NeonEventTypeBeta;
import com.trx.neon.api.neonEnvironment.model.DownloadOptions;
import com.trx.neon.api.neonEnvironment.model.DownloadResult;
import com.trx.neon.api.neonEnvironment.model.LatLong;
import com.trx.neon.api.neonEnvironment.model.LatLongRect;
import com.trx.neon.api.neonEnvironment.model.NeonBuilding;
import com.trx.neon.api.neonEnvironment.model.NeonBuildingFloor;
import com.trx.neon.api.neonEnvironment.model.NeonFloorPlan;
import com.trx.neon.api.neonEnvironment.model.interfaces.INeonBuildingListener;
import com.trx.neon.api.neonEnvironment.model.interfaces.INeonFloorPlanListener;
import com.trx.neon.api.neonRouting.model.PointOfInterest;
import com.trx.neon.api.neonRouting.model.interfaces.INeonPointOfInterestListener;
import com.trx.neon.binder.BuildingBinder;
import com.trx.neon.binder.BuildingConnectionBinder;
import com.trx.neon.binder.MapperBinder;
import com.trx.neon.binder.MapperConnectionBinder;
import com.trx.neon.binder.NavigationBinder;
import com.trx.neon.binder.NavigationConnectionBinder;
import com.trx.neon.binder.NeonAuthBinder;
import com.trx.neon.binder.NeonBinder;
import com.trx.neon.binder.OnBuildingsCallback;
import com.trx.neon.binder.OnChange;
import com.trx.neon.binder.OnChangeAuthenticationEvent;
import com.trx.neon.binder.OnChangeBoolean;
import com.trx.neon.binder.OnChangeCalibrationEvent;
import com.trx.neon.binder.OnChangeConnectivityEvent;
import com.trx.neon.binder.OnChangeMotionLevelEvent;
import com.trx.neon.binder.OnChangeNavLockEvent;
import com.trx.neon.binder.OnChangeNavResetEvent;
import com.trx.neon.binder.OnChangeNeonLocationListV6;
import com.trx.neon.binder.OnChangeNewFloorEvent;
import com.trx.neon.binder.OnChangePostureEvent;
import com.trx.neon.binder.OnChangeSessionEventV2;
import com.trx.neon.binder.OnChangeString;
import com.trx.neon.binder.OnChangeUpdateAvailableEvent;
import com.trx.neon.binder.OnChangeVehicleStateEvent;
import com.trx.neon.binder.OnLoginResult;
import com.trx.neon.binder.OnNeonEvent;
import com.trx.neon.binder.OnNeonEventBeta;
import com.trx.neon.binder.OnPointsOfInterestCallback;
import com.trx.neon.binder.PublicSettingsBinder;
import com.trx.neon.binder.PublicSettingsConnectionBinder;
import com.trx.neon.binder.RoutingBinder;
import com.trx.neon.binder.RoutingConnectionBinder;
import com.trx.neon.binder.ServiceConnectionBinder;
import com.trx.neon.binder.ServiceStatusBinder;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class NeonImpl {
    private static int idGen = 0;
    private static final String LOG_TAG = "NeonImpl";
    private static final String NEON_SERVICE_NAME = "com.trx.neon.framework.INTENT_SERVICE_NEON_SERVICE";
    private static final String NEON_SERVICE_PACKAGE = "com.trx.neon.locationservice";
    private Handler h;
    private final NeonLocationCache locationCache = new NeonLocationCache();
    private final NeonEventCache eventCache = new NeonEventCache();
    private final NeonEventCacheBeta eventCacheBeta = new NeonEventCacheBeta();
    private final CopyOnWriteArrayList<FilteredLocationListener> locationListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<FilteredEventListener> eventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<FilteredEventListenerBeta> eventListenersBeta = new CopyOnWriteArrayList();
    private boolean isBound;
    private NeonServiceConnection conn = null;
    private ServiceConnectionState boundState = null;
    private final Queue<GPSConstraint> depositedGPSConstraints = new LinkedList<GPSConstraint>();
    private final Queue<LineSegmentConstraint> depositedLineSegmentConstraints = new LinkedList<LineSegmentConstraint>();
    private final Queue<ManualConstraint> depositedManualConstraints = new LinkedList<ManualConstraint>();
    private final Queue<RangingConstraint> depositedRangingConstraints = new LinkedList<RangingConstraint>();
    private final Queue<DebugLocation> depositedDebugLocations = new LinkedList<DebugLocation>();
    private long ElapsedRealtimeOffset = System.currentTimeMillis() - SystemClock.elapsedRealtime();
    public static final NeonImpl neon = new NeonImpl();
    public static final String FILE_PATH = "com.trx.neon.locationservice.files";
    public static final String FLOORPLANS = "floorplans";
    public static final String DOWNLOAD_CONNECTIVITY_FAILURE = "FAILURE_CONNECTIVITY";
    public static final String DOWNLOAD_FATAL_FAILURE = "FAILURE_FATAL";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String DOWNLOAD_FLOORPLAN = "DownloadFloorplan";
    public static final String BLOCKING = "BLOCKING";
    public static final String REGULAR = "REGULAR";
    public static final String FILE_ID = "FILE_ID";
    public static final String FILE_TYPE = "FILE_TYPE";
    private WeakReference<Context> boundContext;

    public static void checkLocation(double latitude, double longitude) {
        if (!(longitude >= -180.0 && longitude <= 180.0 && latitude >= -90.0 && latitude <= 90.0)) {
            throw new IllegalArgumentException("Location is not valid: latitude " + latitude + ", longitude " + longitude);
        }
    }

    private NeonImpl() {
        this.locationListeners.add(new FilteredLocationListener(this.locationCache, NeonLocationType.CURRENT, true, "NeonImpl Cache"));
        this.eventListeners.add(new FilteredEventListener(this.eventCache, EnumSet.allOf(NeonEventType.class), true));
        this.eventListenersBeta.add(new FilteredEventListenerBeta(this.eventCacheBeta, EnumSet.allOf(NeonEventTypeBeta.class), true));
    }

    public static boolean isNeonServiceInstalled(Context c) {
        boolean app_installed;
        PackageManager pm = c.getPackageManager();
        try {
            pm.getPackageInfo(NEON_SERVICE_PACKAGE, 1);
            app_installed = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            app_installed = false;
        }
        return app_installed;
    }

    public synchronized long getElapsedRealtimeOffset() {
        return this.ElapsedRealtimeOffset;
    }

    public synchronized String getLocationServiceVersion(Context c) {
        try {
            PackageInfo pInfo = c.getPackageManager().getPackageInfo(NEON_SERVICE_PACKAGE, 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "ERROR: LOCATION SERVICE NOT FOUND";
        }
    }

    public synchronized void upgradeNeonLocationServices(Activity visibleActivity) {
        this.upgradeNeonLocationServices(visibleActivity, false);
    }

    public synchronized void upgradeNeonLocationServices(Activity visibleActivity, boolean mandatoryUpdate) {
        String ACTIVITY_UPGRADE = "com.trx.neon.framework.app.AUTO_UPGRADE";
        if (visibleActivity != null) {
            Intent intent = new Intent(ACTIVITY_UPGRADE);
            intent.putExtra("downloadIsMandatory", mandatoryUpdate);
            visibleActivity.startActivity(intent);
        }
    }

    public synchronized void upgradeDeviceFirmware(Activity visibleActivity) {
        String ACTIVITY_FIRMWARE_UPGRADE = "com.trx.neon.framework.app.FirmwareUpgradeActivity";
        if (visibleActivity != null) {
            visibleActivity.startActivity(new Intent(ACTIVITY_FIRMWARE_UPGRADE));
        }
    }

    public synchronized void upgradeDeviceFirmware(Activity visibleActivity, int requestCode) {
        String ACTIVITY_FIRMWARE_UPGRADE = "com.trx.neon.framework.app.FirmwareUpgradeActivity";
        if (visibleActivity != null) {
            visibleActivity.startActivityForResult(new Intent(ACTIVITY_FIRMWARE_UPGRADE), requestCode);
        }
    }

    public synchronized boolean startLoginActivityForResult(int requestCode, Activity visibleActivity, boolean forceLogOut) {
        Intent loginIntent = new Intent("com.trx.neon.framework.auth.LOGIN");
        if (loginIntent.resolveActivity(visibleActivity.getPackageManager()) != null) {
            loginIntent.putExtra("forceLogOut", forceLogOut);
            visibleActivity.startActivityForResult(loginIntent, requestCode);
            return true;
        }
        return false;
    }

    public synchronized void registerLocationUpdates(INeonLocationListener listener, NeonLocationType type, String tag) {
        NeonLocation loc;
        FilteredLocationListener fll = new FilteredLocationListener(listener, type, tag);
        if (this.isBound && (loc = this.locationCache.loc) != null) {
            ArrayList<NeonLocation> dls = new ArrayList<NeonLocation>();
            dls.add(loc);
            fll.onLocationChanged(dls);
        }
        this.locationListeners.add(fll);
    }

    public synchronized void registerEvents(INeonEventListener listener, EnumSet<NeonEventType> events) {
        FilteredEventListener eventListener = new FilteredEventListener(listener, events);
        if (this.isBound) {
            for (Map.Entry<String, INeonEvent> foo : this.eventCache.events.entrySet()) {
                eventListener.onEvent(foo.getValue().getEventType(), foo.getValue());
            }
        }
        this.eventListeners.add(eventListener);
    }

    public synchronized void registerEventsBeta(INeonEventListenerBeta listener, EnumSet<NeonEventTypeBeta> events) {
        FilteredEventListenerBeta eventListener = new FilteredEventListenerBeta(listener, events);
        if (this.isBound) {
            for (Map.Entry<NeonEventTypeBeta, INeonEventBeta> foo : this.eventCacheBeta.events.entrySet()) {
                eventListener.onEvent(foo.getKey(), foo.getValue());
            }
        }
        this.eventListenersBeta.add(eventListener);
    }

    public synchronized void addRangingConstraint(RangingConstraint constraint) {
        this.depositedRangingConstraints.add(constraint);
        this.flushRangingConstraints();
    }

    public synchronized void addManualConstraint(ManualConstraint constraint) {
        this.depositedManualConstraints.add(constraint);
        this.flushManualConstraints();
    }

    public synchronized void addGPSConstraint(GPSConstraint constraint) {
        this.depositedGPSConstraints.add(constraint);
        this.flushGPSConstraints();
    }

    public synchronized void addLineSegmentConstraint(LineSegmentConstraint constraint) {
        this.depositedLineSegmentConstraints.add(constraint);
        this.flushLineSegmentConstraints();
    }

    public synchronized void addDebugLocation(DebugLocation location) {
        this.depositedDebugLocations.add(location);
        this.flushDebugLocations();
    }

    public synchronized boolean unregisterLocationUpdates(INeonLocationListener listener) {
        return this.locationListeners.remove(new FilteredLocationListener(listener, NeonLocationType.CURRENT, ""));
    }

    public synchronized boolean unregisterEvents(INeonEventListener listener) {
        return this.eventListeners.remove(new FilteredEventListener(listener, EnumSet.noneOf(NeonEventType.class)));
    }

    public synchronized boolean unregisterEventsBeta(INeonEventListenerBeta listener) {
        return this.eventListenersBeta.remove(new FilteredEventListenerBeta(listener, EnumSet.noneOf(NeonEventTypeBeta.class)));
    }

    public void downloadBuildingsInArea(LatLongRect rect, final Handler h, final INeonBuildingListener callback, DownloadOptions downloadOptions) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            if (h == null) {
                return;
            }
            h.post(new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onComplete(new ArrayList<NeonBuilding>(), DownloadResult.CONNECTION_ERROR);
                    }
                }
            });
            return;
        }
        BuildingBinder bBinder = scs.buildingBinder;
        if (bBinder == null) {
            if (h == null) {
                return;
            }
            h.post(new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onComplete(new ArrayList<NeonBuilding>(), DownloadResult.CONNECTION_ERROR);
                    }
                }
            });
            return;
        }
        try {
            OnBuildingsCallback.Stub toHandlerBuildingCallback = new OnBuildingsCallback.Stub(){

                @Override
                public void onComplete(final List<NeonBuilding> buildings, final DownloadResult result) throws RemoteException {
                    if (h == null) {
                        return;
                    }
                    h.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onComplete(buildings, result);
                            }
                        }
                    });
                }
            };
            bBinder.downloadBuildingsInArea(rect, toHandlerBuildingCallback, downloadOptions);
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"remote exception", (Throwable)e);
        }
    }

    public synchronized NeonBuilding getBuilding(UUID id) {
        if (!this.isBound) {
            return null;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return null;
        }
        BuildingBinder bBinder = scs.buildingBinder;
        if (bBinder == null) {
            return null;
        }
        try {
            return bBinder.getBuilding(id.toString());
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"remote exception", (Throwable)e);
            return null;
        }
    }

    public synchronized void getPointsOfInterest(final String buildingID, LatLong location, final Handler h, final INeonPointOfInterestListener poiListener) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            if (h == null) {
                return;
            }
            h.post(new Runnable(){

                @Override
                public void run() {
                    if (poiListener != null) {
                        poiListener.onComplete(buildingID, new ArrayList<PointOfInterest>());
                    }
                }
            });
            return;
        }
        RoutingBinder rBinder = scs.routingBinder;
        if (rBinder == null) {
            if (h == null) {
                return;
            }
            h.post(new Runnable(){

                @Override
                public void run() {
                    if (poiListener != null) {
                        poiListener.onComplete(buildingID, new ArrayList<PointOfInterest>());
                    }
                }
            });
            return;
        }
        try {
            OnPointsOfInterestCallback.Stub toHandlerPointOfInterestCallback = new OnPointsOfInterestCallback.Stub(){

                @Override
                public void onComplete(final String buildingID, final List<PointOfInterest> pointsOfInterest) throws RemoteException {
                    if (h == null) {
                        return;
                    }
                    h.post(new Runnable(){

                        @Override
                        public void run() {
                            if (poiListener != null) {
                                poiListener.onComplete(buildingID, pointsOfInterest);
                            }
                        }
                    });
                }
            };
            rBinder.getPointsOfInterest(buildingID, location, toHandlerPointOfInterestCallback);
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"remote exception", (Throwable)e);
        }
    }

    public static Uri getFileURI(String fileType, String fileName) {
        return new Uri.Builder().scheme("content").authority(FILE_PATH).path(fileType).appendPath(fileName).build();
    }

    private Bitmap decodeSampledBitmap(FileDescriptor fileDescriptor, int maxTextureWidth, int maxTextureHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > maxTextureHeight || width > maxTextureWidth) {
            while (height / inSampleSize > maxTextureHeight || width / inSampleSize > maxTextureWidth) {
                inSampleSize *= 2;
            }
        }
        if (height / inSampleSize == 0 || width / inSampleSize == 0) {
            return null;
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    public synchronized void getFloorPlan(Context context, final NeonBuildingFloor floor, Handler handler, final INeonFloorPlanListener callback) {
        if (floor == null || !floor.hasFloorPlan()) {
            if (callback == null) {
                return;
            }
            handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onComplete(null, INeonFloorPlanListener.ImageResult.FATAL_ERROR);
                }
            });
            return;
        }
        this.tryGetFloorplan(context, floor.getFloorPlanImageID(), handler, new Delegate<FileWithStatus>(){

            @Override
            public void run(FileWithStatus fileStatus) {
                if (callback == null) {
                    return;
                }
                switch (fileStatus.status) {
                    case CONNECTIVITY_FAILURE: {
                        callback.onComplete(null, INeonFloorPlanListener.ImageResult.CONNECTION_ERROR);
                        break;
                    }
                    case FATAL_FAILURE: {
                        callback.onComplete(null, INeonFloorPlanListener.ImageResult.FATAL_ERROR);
                        break;
                    }
                    case SUCCESS: {
                        Bitmap bm = NeonImpl.this.decodeSampledBitmap(fileStatus.file.getFileDescriptor(), 2048, 2048);
                        try {
                            fileStatus.file.close();
                        }
                        catch (IOException e) {
                            Log.e((String)NeonImpl.LOG_TAG, (String)"Can't close file descriptor");
                        }
                        NeonFloorPlan neonFloorplan = new NeonFloorPlan(bm, floor);
                        callback.onComplete(neonFloorplan, INeonFloorPlanListener.ImageResult.SUCCESS);
                        break;
                    }
                }
            }
        });
    }

    private void tryGetFloorplan(Context context, String floorplanID, Handler handler, final Delegate<FileWithStatus> delegate) {
        ParcelFileDescriptor fileDescriptor = this.getFloorplan(context, floorplanID);
        if (fileDescriptor != null) {
            final FileWithStatus status = new FileWithStatus();
            status.file = fileDescriptor;
            status.status = FileWithStatus.FileStatus.SUCCESS;
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        delegate.run(status);
                    }
                    finally {
                        status.close();
                    }
                }
            });
            return;
        }
        this.downloadFloorplan(context, floorplanID, handler, delegate, false);
    }

    private ParcelFileDescriptor getFloorplan(Context context, String floorplanID) {
        ContentResolver resolver = context.getContentResolver();
        try {
            return resolver.openFileDescriptor(NeonImpl.getFileURI(FLOORPLANS, floorplanID), "r");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void downloadFloorplan(final Context context, final String floorplanID, Handler handler, final Delegate<FileWithStatus> downloadStatus, boolean blocking) {
        final ContentResolver resolver = context.getContentResolver();
        Bundle bundle = new Bundle();
        bundle.putString(FILE_ID, floorplanID);
        bundle.putInt(FILE_TYPE, 1);
        if (downloadStatus != null) {
            ContentObserver observer = new ContentObserver(handler){

                public void onChange(boolean selfChange, Uri uri) {
                    super.onChange(selfChange);
                    resolver.unregisterContentObserver((ContentObserver)this);
                    if (uri.getLastPathSegment().equals(floorplanID)) {
                        try (FileWithStatus ret = new FileWithStatus();){
                            ret.status = FileWithStatus.FileStatus.SUCCESS;
                            ret.file = NeonImpl.this.getFloorplan(context, floorplanID);
                            downloadStatus.run(ret);
                        }
                    }
                    if (uri.getLastPathSegment().equals(NeonImpl.DOWNLOAD_CONNECTIVITY_FAILURE)) {
                        try (FileWithStatus ret = new FileWithStatus();){
                            ret.status = FileWithStatus.FileStatus.CONNECTIVITY_FAILURE;
                            ret.file = null;
                            downloadStatus.run(ret);
                        }
                    }
                    if (uri.getLastPathSegment().equals(NeonImpl.DOWNLOAD_FATAL_FAILURE)) {
                        try (FileWithStatus ret = new FileWithStatus();){
                            ret.status = FileWithStatus.FileStatus.FATAL_FAILURE;
                            ret.file = null;
                            downloadStatus.run(ret);
                        }
                    }
                }
            };
            resolver.registerContentObserver(NeonImpl.getFileURI(FLOORPLANS, floorplanID), true, observer);
        }
        NeonImpl.call(resolver, NeonImpl.getFileURI(FLOORPLANS, null), DOWNLOAD_FLOORPLAN, blocking ? BLOCKING : REGULAR, bundle);
    }

    private static Bundle call(ContentResolver resolver, Uri uri, String method, String parameters, Bundle extras) {
        try {
            return resolver.call(uri, method, parameters, extras);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOG_TAG, (String)"Client is updated but NeonLocationService is outdated, unable to do operation");
            return null;
        }
        catch (SecurityException e) {
            Log.e((String)LOG_TAG, (String)"Client is updated but NeonLocationService is outdated, unable to do operation");
            return null;
        }
    }

    @Deprecated
    public synchronized void downloadArea(double[] coordinates, OnChangeBoolean onChangeBoolean) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        try {
            navBinder.downloadArea(coordinates, new ToHandlerOnChangeBoolean(this.h, onChangeBoolean));
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"remote exception", (Throwable)e);
        }
    }

    public synchronized boolean bind(Context c, Handler h) {
        if (h == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        if (this.isBound) {
            throw new IllegalStateException("Cannot bind Neon while already bound");
        }
        this.conn = new NeonServiceConnection();
        Intent intent = new Intent(NEON_SERVICE_NAME);
        intent.setPackage(NEON_SERVICE_PACKAGE);
        this.isBound = c.bindService(intent, (ServiceConnection)this.conn, 1);
        if (this.isBound) {
            this.boundContext = new WeakReference<Context>(c);
            this.h = h;
        }
        return this.isBound;
    }

    public synchronized void unbind() {
        Context oldC;
        if (!this.isBound) {
            throw new IllegalStateException("Cannot unbind Neon while not bound");
        }
        this.conn.setCanceled(true);
        if (this.boundState != null) {
            this.boundState.unregisterAll();
        }
        if ((oldC = (Context)this.boundContext.get()) != null) {
            oldC.unbindService((ServiceConnection)this.conn);
        }
        this.isBound = false;
        this.h = null;
        this.boundState = null;
        this.conn = null;
        this.locationCache.clear();
        this.eventCache.clear();
        this.eventCacheBeta.clear();
    }

    public synchronized void login(Account a, OnLoginResult callback) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NeonBinder binder = scs.neonBinder;
        if (binder == null) {
            return;
        }
        try {
            binder.login(a, callback);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public synchronized void login(String apiKey, OnLoginResult callback) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NeonBinder binder = scs.neonBinder;
        if (binder == null) {
            return;
        }
        try {
            binder.login(new Account(apiKey, "com.trx.apikey"), callback);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private synchronized void onConnect(NeonServiceConnection connection, IBinder service) {
        NeonBinder binder;
        if (connection.isCanceled()) {
            return;
        }
        try {
            binder = NeonAuthBinder.Stub.asInterface(service).awaitUserLogin();
            if (binder == null) {
                Log.w((String)LOG_TAG, (String)"User rejected this application");
                return;
            }
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"Couldn't stay connected to Neon Location Services", (Throwable)e);
            return;
        }
        this.boundState = new ServiceConnectionState(connection, binder);
        this.boundState.registerAll();
    }

    private void onDisconnect() {
        this.fireEvent(new BindingEvent(System.currentTimeMillis(), BindingEvent.BindingEventType.FATAL_DISCONNECT), NeonEventType.BINDING);
    }

    private void fireEvent(INeonEvent e, NeonEventType type) {
        for (FilteredEventListener fel : this.eventListeners) {
            fel.onEvent(type, e);
        }
    }

    private void fireLocation(List<NeonLocation> locs) {
        for (FilteredLocationListener fll : this.locationListeners) {
            fll.onLocationChanged(locs);
        }
    }

    private void fireEvent(INeonEventBeta e, NeonEventTypeBeta type) {
        for (FilteredEventListenerBeta fel : this.eventListenersBeta) {
            fel.onEvent(type, e);
        }
    }

    private synchronized void flushGPSConstraints() {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        while (!this.depositedGPSConstraints.isEmpty()) {
            GPSConstraint nc = this.depositedGPSConstraints.peek();
            try {
                navBinder.addGPSConstraint(nc);
            }
            catch (RemoteException e) {
                Log.w((String)LOG_TAG, (String)"Couldn't add GPS Constraint due to remote exception, may try again later.", (Throwable)e);
                break;
            }
            this.depositedGPSConstraints.poll();
        }
    }

    private synchronized void flushManualConstraints() {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        while (!this.depositedManualConstraints.isEmpty()) {
            ManualConstraint nc = this.depositedManualConstraints.peek();
            try {
                navBinder.addManualConstraint(nc);
            }
            catch (RemoteException e) {
                Log.w((String)LOG_TAG, (String)"Couldn't add Manual Constraint due to remote exception, may try again later.", (Throwable)e);
                break;
            }
            this.depositedManualConstraints.poll();
        }
    }

    private synchronized void flushLineSegmentConstraints() {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        while (!this.depositedLineSegmentConstraints.isEmpty()) {
            LineSegmentConstraint nc = this.depositedLineSegmentConstraints.peek();
            try {
                navBinder.addLineSegmentConstraint(nc);
            }
            catch (RemoteException e) {
                Log.w((String)LOG_TAG, (String)"Couldn't add Line Segment Constraint due to remote exception, may try again later.", (Throwable)e);
                break;
            }
            this.depositedLineSegmentConstraints.poll();
        }
    }

    private synchronized void flushRangingConstraints() {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        while (!this.depositedRangingConstraints.isEmpty()) {
            RangingConstraint nc = this.depositedRangingConstraints.peek();
            try {
                navBinder.addRangingConstraint(nc);
            }
            catch (RemoteException e) {
                Log.w((String)LOG_TAG, (String)"Couldn't add Ranging Constraint due to remote exception, may try again later.", (Throwable)e);
                break;
            }
            this.depositedRangingConstraints.poll();
        }
    }

    private synchronized void flushDebugLocations() {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        while (!this.depositedDebugLocations.isEmpty()) {
            DebugLocation dl = this.depositedDebugLocations.peek();
            try {
                navBinder.setDebugLocation(dl);
            }
            catch (RemoteException e) {
                Log.w((String)LOG_TAG, (String)"Couldn't user correct due to remote exception, may try again later.", (Throwable)e);
                break;
            }
            this.depositedDebugLocations.poll();
        }
    }

    private String getID() {
        return "{" + UUID.randomUUID().toString() + "}";
    }

    public String startMapping() {
        Log.i((String)LOG_TAG, (String)"Calling startMapping");
        if (!this.isBound) {
            Log.e((String)LOG_TAG, (String)"Not bound");
            return null;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            Log.e((String)LOG_TAG, (String)"boundState is null");
            return null;
        }
        MapperBinder mapperBinder = scs.mapperBinder;
        if (mapperBinder == null) {
            Log.e((String)LOG_TAG, (String)"routeBinder is null");
            return null;
        }
        try {
            String mapID = this.getID();
            mapperBinder.startMapperMode(mapID);
            return mapID;
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Error starting mapper mode.", (Throwable)e);
            Log.e((String)LOG_TAG, (String)"Something went wrong in start mapping");
            return null;
        }
    }

    public boolean stopMapping(String mapID) {
        Log.i((String)LOG_TAG, (String)("Calling stopMapping " + mapID));
        if (!this.isBound) {
            Log.e((String)LOG_TAG, (String)"Not bound");
            return false;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            Log.e((String)LOG_TAG, (String)"boundState is null");
            return false;
        }
        MapperBinder mapperBinder = scs.mapperBinder;
        if (mapperBinder == null) {
            Log.e((String)LOG_TAG, (String)"routeBinder is null");
            return false;
        }
        try {
            return mapperBinder.stopMapperMode(mapID);
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Error stopping mapper mode.", (Throwable)e);
            Log.e((String)LOG_TAG, (String)"Something went wrong in stop mapping");
            return false;
        }
    }

    public boolean uploadMap(String mapID, final OnChangeString uploadSuccessEvent, final OnChange uploadFailEvent) {
        Log.i((String)LOG_TAG, (String)("Calling uploadMap " + mapID));
        if (!this.isBound) {
            Log.e((String)LOG_TAG, (String)"Not bound");
            return false;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            Log.e((String)LOG_TAG, (String)"boundState is null");
            return false;
        }
        MapperBinder mapperBinder = scs.mapperBinder;
        if (mapperBinder == null) {
            Log.e((String)LOG_TAG, (String)"routeBinder is null");
            return false;
        }
        try {
            OnChangeString.Stub toHandlerUploadSuccessEvent = new OnChangeString.Stub(){

                @Override
                public void onChange(final String str) throws RemoteException {
                    NeonImpl.this.h.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                uploadSuccessEvent.onChange(str);
                            }
                            catch (RemoteException e) {
                                Log.e((String)NeonImpl.LOG_TAG, (String)"in toHandlerUploadSuccessEvent", (Throwable)e);
                            }
                        }
                    });
                }
            };
            OnChange.Stub toHandlerUploadFailEvent = new OnChange.Stub(){

                @Override
                public void onChange() throws RemoteException {
                    NeonImpl.this.h.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                uploadFailEvent.onChange();
                            }
                            catch (RemoteException e) {
                                Log.e((String)NeonImpl.LOG_TAG, (String)"in toHandlerUploadFailEvent", (Throwable)e);
                            }
                        }
                    });
                }
            };
            return mapperBinder.uploadMap(mapID, toHandlerUploadSuccessEvent, toHandlerUploadFailEvent);
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Error uploading map.", (Throwable)e);
            Log.e((String)LOG_TAG, (String)"Something went wrong in stop map");
            return false;
        }
    }

    public boolean closeMap(String mapID) {
        Log.i((String)LOG_TAG, (String)("Calling closeMap: " + mapID));
        if (!this.isBound) {
            Log.e((String)LOG_TAG, (String)"Not bound");
            return false;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            Log.e((String)LOG_TAG, (String)"boundState is null");
            return false;
        }
        MapperBinder mapperBinder = scs.mapperBinder;
        if (mapperBinder == null) {
            Log.e((String)LOG_TAG, (String)"routeBinder is null");
            return false;
        }
        try {
            return mapperBinder.deleteMap(mapID);
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Error deleting map.", (Throwable)e);
            Log.e((String)LOG_TAG, (String)"Something went wrong in delete map");
            return false;
        }
    }

    public void processInertialDelta(NeonInertialDelta delta) {
        if (!this.isBound) {
            return;
        }
        ServiceConnectionState scs = this.boundState;
        if (scs == null) {
            return;
        }
        NavigationBinder navBinder = scs.realNavBinder;
        if (navBinder == null) {
            return;
        }
        try {
            navBinder.depositExternalInertialDelta(delta);
        }
        catch (RemoteException e) {
            Log.w((String)LOG_TAG, (String)"Couldn't deposit external InertialDelta due to remote exception", (Throwable)e);
        }
    }

    static /* synthetic */ int access$1808() {
        return idGen++;
    }

    private final class ServiceConnectionState {
        public final NeonServiceConnection owner;
        public final PublicSettingsConnectionBinder.Stub setStartup;
        public final ServiceConnectionBinder.Stub servBinder;
        public final NavigationConnectionBinder.Stub navBinder;
        public final MapperConnectionBinder.Stub mapperConnBinder;
        public final BuildingConnectionBinder.Stub buildingConnBinder;
        public final RoutingConnectionBinder.Stub routingConnBinder;
        public final OnChangeConnectivityEvent.Stub servConnectivityEvent;
        public final OnChangeAuthenticationEvent.Stub authenticationEvent;
        public final OnChangeCalibrationEvent.Stub navCalibrationEvent;
        public final OnChangeMotionLevelEvent.Stub navMotionLevelEvent;
        public final OnChangePostureEvent.Stub navPostureEvent;
        public final OnChangeSessionEventV2.Stub navSessionEvent;
        public final OnChangeNeonLocationListV6.Stub navLocationEvent;
        public final OnChangeVehicleStateEvent.Stub navVehicleStateEvent;
        public final OnChangeNavResetEvent.Stub navResetEvent;
        public final OnChangeNavLockEvent.Stub navLockEvent;
        public final OnChangeNewFloorEvent.Stub newFloorEvent;
        public final OnChangeUpdateAvailableEvent.Stub updateAvailableEvent;
        public final OnChangeBoolean.Stub runningEvent;
        public final OnNeonEvent.Stub messagingEvents;
        public final OnNeonEventBeta.Stub messagingEventsBeta;
        public NeonBinder neonBinder = null;
        public NavigationBinder realNavBinder = null;
        public ServiceStatusBinder servStatusBinder = null;
        public MapperBinder mapperBinder = null;
        public BuildingBinder buildingBinder = null;
        public RoutingBinder routingBinder = null;
        public PublicSettingsBinder publicSettingsBinder = null;
        public final Object registrationLock = new Object();

        public ServiceConnectionState(NeonServiceConnection owningConnection, NeonBinder binder) {
            this.owner = owningConnection;
            this.neonBinder = binder;
            this.updateAvailableEvent = new OnChangeUpdateAvailableEvent.Stub(){

                @Override
                public void onChange(UpdateAvailableEvent s) throws RemoteException {
                    NeonImpl.this.fireEvent(s, NeonEventType.UPDATE_AVAILABLE);
                }
            };
            this.runningEvent = new OnChangeBoolean.Stub(){

                @Override
                public void onChange(boolean b) {
                    if (b) {
                        NeonImpl.this.fireEvent(new BindingEvent(System.currentTimeMillis(), BindingEvent.BindingEventType.CONNECT), NeonEventType.BINDING);
                    } else {
                        NeonImpl.this.fireEvent(new BindingEvent(System.currentTimeMillis(), BindingEvent.BindingEventType.DISCONNECT), NeonEventType.BINDING);
                    }
                }
            };
            this.messagingEvents = new OnNeonEvent.Stub(){

                @Override
                public void onBatteryEvent(BatteryEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.BATTERY);
                }

                @Override
                public void onCalibrationEvent(CalibrationEvent ev) throws RemoteException {
                }

                @Override
                public void onConnectivityEvent(ConnectivityEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.CONNECTIVITY);
                }

                @Override
                public void onMotionLevelEvent(MotionLevelEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.MOTION_LEVEL);
                }

                @Override
                public void onPostureEvent(PostureEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.POSTURE);
                }

                @Override
                public void onRemoteRangeEvent(RemoteRangeEvent ev) throws RemoteException {
                }

                @Override
                public void onSafetyAlertEvent(SafetyAlertEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.SAFETY_ALERT);
                }

                @Override
                public void onSessionEvent(SessionEventLegacy ev) throws RemoteException {
                }

                @Override
                public void onStructuralFeatureEvent(StructuralFeatureEvent ev) throws RemoteException {
                }

                @Override
                public void onUpdateAvailableEvent(UpdateAvailableEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.UPDATE_AVAILABLE);
                }

                @Override
                public void onVehicleStateEvent(VehicleStateEvent ev) throws RemoteException {
                }

                @Override
                public void onMapperStructuralFeatureEvent(MapperStructuralFeatureEvent ev) throws RemoteException {
                }

                @Override
                public void onNavResetEvent(NavResetEvent ev) throws RemoteException {
                }

                @Override
                public void onNavLockEvent(NavLockEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.NAV_LOCK);
                }

                @Override
                public void onNewFloorEvent(NewFloorEvent ev) throws RemoteException {
                }

                @Override
                public void onSessionEventV2(SessionEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.SESSION);
                }

                @Override
                public void onAuthenticationEvent(AuthenticationEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventType.AUTHENTICATION);
                }
            };
            this.messagingEventsBeta = new OnNeonEventBeta.Stub(){

                @Override
                public void onUserActivityEvent(UserActivityEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.USER_ACTIVITY);
                }

                @Override
                public void onWarfighterEvent(WarfighterEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.WARFIGHTER);
                }

                @Override
                public void onCalibrationEvent(CalibrationEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.CALIBRATION);
                }

                @Override
                public void onRemoteRangeEvent(RemoteRangeEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.REMOTE_RANGE);
                }

                @Override
                public void onVehicleStateEvent(VehicleStateEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.VEHICLE);
                }

                @Override
                public void onNavResetEvent(NavResetEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.NAV_RESET);
                }

                @Override
                public void onNewFloorEvent(NewFloorEvent ev) throws RemoteException {
                    NeonImpl.this.fireEvent(ev, NeonEventTypeBeta.NEW_FLOOR);
                }
            };
            this.setStartup = new PublicSettingsConnectionBinder.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(PublicSettingsBinder b) {
                    Object object = ServiceConnectionState.this.registrationLock;
                    synchronized (object) {
                        if (ServiceConnectionState.this.owner.isCanceled()) {
                            return;
                        }
                        ServiceConnectionState.this.publicSettingsBinder = b;
                        try {
                            NeonImpl.this.ElapsedRealtimeOffset = b.getLong("elapsedRealtimeOffset");
                        }
                        catch (RemoteException e) {
                            Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to retrieve offset", (Throwable)e);
                        }
                    }
                }

                @Override
                public void onDisconnect() {
                }
            };
            this.servConnectivityEvent = new OnChangeConnectivityEvent.Stub(){
                final int id = NeonImpl.access$1808();

                @Override
                public void onChange(ConnectivityEvent ce) {
                    Log.i((String)NeonImpl.LOG_TAG, (String)("Received Connectivity Event, My ID: " + this.id));
                    NeonImpl.this.fireEvent(ce, NeonEventType.CONNECTIVITY);
                }
            };
            this.authenticationEvent = new OnChangeAuthenticationEvent.Stub(){
                final int id = NeonImpl.access$1808();

                @Override
                public void onChange(AuthenticationEvent ae) {
                    Log.i((String)NeonImpl.LOG_TAG, (String)("Received Authentication Event, My ID: " + this.id));
                    NeonImpl.this.fireEvent(ae, NeonEventType.AUTHENTICATION);
                }
            };
            this.servBinder = new ServiceConnectionBinder.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(ServiceStatusBinder b) {
                    Object object = ServiceConnectionState.this.registrationLock;
                    synchronized (object) {
                        if (ServiceConnectionState.this.owner.isCanceled()) {
                            return;
                        }
                        ServiceConnectionState.this.servStatusBinder = b;
                        try {
                            b.registerConnectivityEventUpdates(ServiceConnectionState.this.servConnectivityEvent);
                        }
                        catch (RemoteException e) {
                            Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to register connectivity event updates");
                        }
                        try {
                            b.registerAuthenticationEventUpdates(ServiceConnectionState.this.authenticationEvent);
                        }
                        catch (RemoteException e) {
                            Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to register authentication event updates");
                        }
                    }
                }

                @Override
                public void onDisconnect() throws RemoteException {
                }
            };
            Log.d((String)NeonImpl.LOG_TAG, (String)"Creating mapperConnBinder");
            this.mapperConnBinder = new MapperConnectionBinder.Stub(){

                @Override
                public void onConnect(MapperBinder binder) throws RemoteException {
                    Log.d((String)NeonImpl.LOG_TAG, (String)"mapperConnBinder's onConnect");
                    ServiceConnectionState.this.mapperBinder = binder;
                }

                @Override
                public void onDisconnect() throws RemoteException {
                }
            };
            this.buildingConnBinder = new BuildingConnectionBinder.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(BuildingBinder binder) throws RemoteException {
                    Log.d((String)NeonImpl.LOG_TAG, (String)"buildingConnBinder's onConnect");
                    Object object = ServiceConnectionState.this.registrationLock;
                    synchronized (object) {
                        if (ServiceConnectionState.this.owner.isCanceled()) {
                            return;
                        }
                        ServiceConnectionState.this.buildingBinder = binder;
                    }
                }

                @Override
                public void onDisconnect() throws RemoteException {
                }
            };
            this.routingConnBinder = new RoutingConnectionBinder.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(RoutingBinder binder) throws RemoteException {
                    Log.d((String)NeonImpl.LOG_TAG, (String)"routingConnBinder's onConnect");
                    Object object = ServiceConnectionState.this.registrationLock;
                    synchronized (object) {
                        if (ServiceConnectionState.this.owner.isCanceled()) {
                            return;
                        }
                        ServiceConnectionState.this.routingBinder = binder;
                    }
                }

                @Override
                public void onDisconnect() throws RemoteException {
                }
            };
            this.navResetEvent = new OnChangeNavResetEvent.Stub(){

                @Override
                public void onChange(NavResetEvent re) {
                    NeonImpl.this.fireEvent(re, NeonEventTypeBeta.NAV_RESET);
                }
            };
            this.newFloorEvent = new OnChangeNewFloorEvent.Stub(){

                @Override
                public void onChange(NewFloorEvent re) {
                    NeonImpl.this.fireEvent(re, NeonEventTypeBeta.NEW_FLOOR);
                }
            };
            this.navCalibrationEvent = new OnChangeCalibrationEvent.Stub(){

                @Override
                public void onChange(CalibrationEvent ce) {
                    NeonImpl.this.fireEvent(ce, NeonEventTypeBeta.CALIBRATION);
                }
            };
            this.navVehicleStateEvent = new OnChangeVehicleStateEvent.Stub(){

                @Override
                public void onChange(VehicleStateEvent ve) {
                    NeonImpl.this.fireEvent(ve, NeonEventTypeBeta.VEHICLE);
                }
            };
            this.navMotionLevelEvent = new OnChangeMotionLevelEvent.Stub(){

                @Override
                public void onChange(MotionLevelEvent mle) {
                    NeonImpl.this.fireEvent(mle, NeonEventType.MOTION_LEVEL);
                }
            };
            this.navPostureEvent = new OnChangePostureEvent.Stub(){

                @Override
                public void onChange(PostureEvent pe) {
                    NeonImpl.this.fireEvent(pe, NeonEventType.POSTURE);
                }
            };
            this.navSessionEvent = new OnChangeSessionEventV2.Stub(){

                @Override
                public void onChange(SessionEvent se) {
                    NeonImpl.this.fireEvent(se, NeonEventType.SESSION);
                }
            };
            this.navLocationEvent = new OnChangeNeonLocationListV6.Stub(){

                @Override
                public void onChange(List<NeonLocation> loc) throws RemoteException {
                    NeonImpl.this.fireLocation(loc);
                }
            };
            this.navLockEvent = new OnChangeNavLockEvent.Stub(){

                @Override
                public void onChange(NavLockEvent re) {
                    NeonImpl.this.fireEvent(re, NeonEventType.NAV_LOCK);
                }
            };
            this.navBinder = new NavigationConnectionBinder.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(NavigationBinder b) throws RemoteException {
                    Object object = ServiceConnectionState.this.registrationLock;
                    synchronized (object) {
                        if (ServiceConnectionState.this.owner.isCanceled()) {
                            return;
                        }
                        ServiceConnectionState.this.realNavBinder = b;
                        b.registerCalibrationEventUpdates(ServiceConnectionState.this.navCalibrationEvent);
                        b.registerMotionLevelEventUpdates(ServiceConnectionState.this.navMotionLevelEvent);
                        b.registerNavResetEventUpdates(ServiceConnectionState.this.navResetEvent);
                        b.registerNavLockEventUpdates(ServiceConnectionState.this.navLockEvent);
                        b.registerNewFloorEventUpdates(ServiceConnectionState.this.newFloorEvent);
                        b.registerPostureEventUpdates(ServiceConnectionState.this.navPostureEvent);
                        b.registerVehicleStateUpdates(ServiceConnectionState.this.navVehicleStateEvent);
                        b.registerSessionUpdatesV2(ServiceConnectionState.this.navSessionEvent);
                        b.registerLocationUpdatesV6(ServiceConnectionState.this.navLocationEvent);
                        NeonImpl.this.flushDebugLocations();
                    }
                }

                @Override
                public void onDisconnect() throws RemoteException {
                }
            };
        }

        public void registerAll() {
            try {
                this.neonBinder.registerForAvailableUpdates(((NeonImpl)NeonImpl.this).boundState.updateAvailableEvent);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to bind for available updates", (Throwable)e);
            }
            try {
                this.neonBinder.registerIsRunningUpdates(this.runningEvent);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to bind running event", (Throwable)e);
            }
            try {
                this.neonBinder.registerForMessagingEvents(this.messagingEvents);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to bind messaging events", (Throwable)e);
            }
            try {
                this.neonBinder.registerForMessagingEventsBeta(this.messagingEventsBeta);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to bind messaging events", (Throwable)e);
            }
            try {
                Log.i((String)NeonImpl.LOG_TAG, (String)"Binding buildingConnBinder");
                this.neonBinder.bindBuildings(((NeonImpl)NeonImpl.this).boundState.buildingConnBinder);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Couldn't start Neon Location Service Mapper", (Throwable)e);
            }
            try {
                Log.i((String)NeonImpl.LOG_TAG, (String)"Binding routingConnBinder");
                this.neonBinder.bindRouting(((NeonImpl)NeonImpl.this).boundState.routingConnBinder);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Couldn't start Neon Location Service Mapper", (Throwable)e);
            }
            try {
                this.neonBinder.bindServices(((NeonImpl)NeonImpl.this).boundState.servBinder);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Couldn't start Neon Location Service services", (Throwable)e);
            }
            try {
                this.neonBinder.bindNavigation(((NeonImpl)NeonImpl.this).boundState.navBinder);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Couldn't start Neon Location Service navigation", (Throwable)e);
            }
            try {
                Log.i((String)NeonImpl.LOG_TAG, (String)"Binding mapperConnBinder");
                this.neonBinder.bindMapper(((NeonImpl)NeonImpl.this).boundState.mapperConnBinder);
            }
            catch (RemoteException e) {
                Log.w((String)NeonImpl.LOG_TAG, (String)"Couldn't start Neon Location Service Mapper", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAll() {
            Object object = this.registrationLock;
            synchronized (object) {
                if (!this.owner.isCanceled()) {
                    throw new IllegalStateException("Potential Race Condition Detected");
                }
            }
            if (this.realNavBinder != null) {
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterCalibrationEventUpdates(this.navCalibrationEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister calibration event updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterMotionLevelEventUpdates(this.navMotionLevelEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister motion level updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterPostureEventUpdates(this.navPostureEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister posture updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterVehicleStateUpdates(this.navVehicleStateEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister vehicle state updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterSessionUpdatesV2(this.navSessionEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister session updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterLocationUpdatesV6(this.navLocationEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister location updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterNavResetEventUpdates(this.navResetEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister nav reset updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterNewFloorEventUpdates(this.newFloorEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister new floor updates");
                }
                try {
                    if (this.realNavBinder != null) {
                        this.realNavBinder.unregisterNavLockEventUpdates(this.navLockEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister nav lock updates");
                }
                try {
                    if (this.neonBinder != null) {
                        this.neonBinder.unbindNavigation(this.navBinder);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind Navigation");
                }
            }
            if (this.servBinder != null) {
                try {
                    if (this.servStatusBinder != null) {
                        this.servStatusBinder.unregisterConnectivityEventUpdates(this.servConnectivityEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister Connectivity");
                }
                try {
                    if (this.servStatusBinder != null) {
                        this.servStatusBinder.unregisterAuthenticationEventUpdates(this.authenticationEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister Authentication");
                }
                try {
                    if (this.neonBinder != null) {
                        this.neonBinder.unbindServices(this.servBinder);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind services");
                }
            }
            if (this.setStartup != null) {
                try {
                    if (this.neonBinder != null) {
                        this.neonBinder.unbindSettings(this.setStartup);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind settings");
                }
            }
            if (this.buildingConnBinder != null) {
                Log.i((String)NeonImpl.LOG_TAG, (String)"buildingConnBinder != null");
                try {
                    if (this.neonBinder != null) {
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder != null");
                        this.neonBinder.unbindBuildings(this.buildingConnBinder);
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder.unbind(buildingConnBinder) called");
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind Buildings");
                }
            } else {
                Log.i((String)NeonImpl.LOG_TAG, (String)"buildingConnBinder == null");
            }
            if (this.routingConnBinder != null) {
                Log.i((String)NeonImpl.LOG_TAG, (String)"routingConnBinder != null");
                try {
                    if (this.neonBinder != null) {
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder != null");
                        this.neonBinder.unbindRouting(this.routingConnBinder);
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder.unbind(routingConnBinder) called");
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind Routing");
                }
            } else {
                Log.i((String)NeonImpl.LOG_TAG, (String)"routingConnBinder == null");
            }
            if (this.updateAvailableEvent != null) {
                try {
                    if (this.neonBinder != null) {
                        this.neonBinder.unregisterForAvailableUpdates(this.updateAvailableEvent);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unregister available update events");
                }
            }
            if (this.runningEvent != null) {
                try {
                    this.neonBinder.unregisterIsRunningUpdates(this.runningEvent);
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to unbind running event", (Throwable)e);
                }
            }
            if (this.messagingEvents != null) {
                try {
                    this.neonBinder.unregisterForMessagingEvents(this.messagingEvents);
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to unbind messaging events", (Throwable)e);
                }
            }
            if (this.messagingEventsBeta != null) {
                try {
                    this.neonBinder.unregisterForMessagingEventsBeta(this.messagingEventsBeta);
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Unable to unbind messaging events beta", (Throwable)e);
                }
            }
            if (this.mapperConnBinder != null) {
                Log.i((String)NeonImpl.LOG_TAG, (String)"mapperConnBinder != null");
                try {
                    if (this.neonBinder != null) {
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder != null");
                        this.neonBinder.unbindMapper(this.mapperConnBinder);
                        Log.i((String)NeonImpl.LOG_TAG, (String)"neonBinder.unbind(mapperConnBinder) called");
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)NeonImpl.LOG_TAG, (String)"Could not unbind Mapper");
                }
            } else {
                Log.i((String)NeonImpl.LOG_TAG, (String)"mapperConnBinder == null");
            }
        }
    }

    private final class FilteredLocationListener {
        private final INeonLocationListener wrapped;
        private final NeonLocationType desired;
        private NeonLocation lastSent;
        private final boolean dontPost;
        private final String tag;

        public FilteredLocationListener(INeonLocationListener toWrap, NeonLocationType desired, String tag) {
            this(toWrap, desired, false, tag);
        }

        public FilteredLocationListener(INeonLocationListener toWrap, NeonLocationType desired, boolean dontPost, String tag) {
            this.wrapped = toWrap;
            this.desired = desired;
            this.lastSent = null;
            this.dontPost = dontPost;
            this.tag = tag;
        }

        public void onLocationChanged(List<NeonLocation> locationUpdate) {
            if (locationUpdate.size() == 0) {
                return;
            }
            switch (this.desired) {
                case CURRENT: {
                    NeonLocation loc = locationUpdate.get(locationUpdate.size() - 1);
                    if (this.lastSent != null && this.lastSent.unixTimeMs >= loc.unixTimeMs) break;
                    this.sendToWrapped(loc);
                    break;
                }
                case PER_STEP: {
                    ArrayList<NeonLocation> locs = new ArrayList<NeonLocation>();
                    for (NeonLocation loc : locationUpdate) {
                        if (this.lastSent != null && this.lastSent.unixTimeMs >= loc.unixTimeMs) continue;
                        locs.add(loc);
                    }
                    this.sendListToWrapped(locs);
                    break;
                }
                case CORRECTED: {
                    this.sendListToWrapped(new ArrayList<NeonLocation>(locationUpdate));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown NeonLocationType: " + (Object)((Object)this.desired));
                }
            }
        }

        private void sendToWrapped(final NeonLocation loc) {
            this.lastSent = loc;
            if (this.dontPost) {
                this.wrapped.onLocationChanged(loc);
            } else {
                Handler handler = NeonImpl.this.h;
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            FilteredLocationListener.this.wrapped.onLocationChanged(loc);
                        }
                    });
                }
            }
        }

        private void sendListToWrapped(final List<NeonLocation> locs) {
            if (locs.isEmpty()) {
                return;
            }
            this.lastSent = locs.get(locs.size() - 1);
            if (this.dontPost) {
                for (NeonLocation loc : locs) {
                    this.wrapped.onLocationChanged(loc);
                }
            } else {
                Handler handler = NeonImpl.this.h;
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            for (NeonLocation loc : locs) {
                                FilteredLocationListener.this.wrapped.onLocationChanged(loc);
                            }
                        }
                    });
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FilteredLocationListener)) {
                return false;
            }
            return this.wrapped == ((FilteredLocationListener)o).wrapped;
        }
    }

    private final class FilteredEventListenerBeta
    implements INeonEventListenerBeta {
        private final INeonEventListenerBeta wrapped;
        private final EnumSet<NeonEventTypeBeta> desired;
        private final boolean dontPost;

        public FilteredEventListenerBeta(INeonEventListenerBeta toWrap, EnumSet<NeonEventTypeBeta> desired) {
            this(toWrap, desired, false);
        }

        public FilteredEventListenerBeta(INeonEventListenerBeta toWrap, EnumSet<NeonEventTypeBeta> desired, boolean dontPost) {
            this.wrapped = toWrap;
            this.desired = desired;
            this.dontPost = dontPost;
        }

        @Override
        public void onEvent(final NeonEventTypeBeta type, final INeonEventBeta ne) {
            if (this.desired.contains((Object)type)) {
                if (this.dontPost) {
                    this.wrapped.onEvent(type, ne);
                } else {
                    Handler handler = NeonImpl.this.h;
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                FilteredEventListenerBeta.this.wrapped.onEvent(type, ne);
                            }
                        });
                    }
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FilteredEventListenerBeta)) {
                return false;
            }
            return this.wrapped == ((FilteredEventListenerBeta)o).wrapped;
        }
    }

    private final class FilteredEventListener
    implements INeonEventListener {
        private final INeonEventListener wrapped;
        private final EnumSet<NeonEventType> desired;
        private final boolean dontPost;

        public FilteredEventListener(INeonEventListener toWrap, EnumSet<NeonEventType> desired) {
            this(toWrap, desired, false);
        }

        public FilteredEventListener(INeonEventListener toWrap, EnumSet<NeonEventType> desired, boolean dontPost) {
            this.wrapped = toWrap;
            this.desired = desired;
            this.dontPost = dontPost;
        }

        @Override
        public void onEvent(final NeonEventType type, final INeonEvent ne) {
            if (this.desired.contains((Object)type)) {
                if (this.dontPost) {
                    this.wrapped.onEvent(type, ne);
                } else {
                    Handler handler = NeonImpl.this.h;
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                FilteredEventListener.this.wrapped.onEvent(type, ne);
                            }
                        });
                    }
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FilteredEventListener)) {
                return false;
            }
            return this.wrapped == ((FilteredEventListener)o).wrapped;
        }
    }

    private final class NeonServiceConnection
    implements ServiceConnection {
        private boolean canceled = false;

        private NeonServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            NeonImpl.this.onConnect(this, service);
        }

        public void onServiceDisconnected(ComponentName name) {
            NeonImpl.this.onDisconnect();
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized void setCanceled(boolean cancel) {
            this.canceled = cancel;
        }
    }

    private static final class NeonEventCacheBeta
    implements INeonEventListenerBeta {
        public final ConcurrentHashMap<NeonEventTypeBeta, INeonEventBeta> events = new ConcurrentHashMap();

        private NeonEventCacheBeta() {
        }

        @Override
        public void onEvent(NeonEventTypeBeta type, INeonEventBeta ne) {
            this.events.put(type, ne);
        }

        public void clear() {
            this.events.clear();
        }
    }

    private static final class NeonEventCache
    implements INeonEventListener {
        public final ConcurrentHashMap<String, INeonEvent> events = new ConcurrentHashMap();

        private NeonEventCache() {
        }

        @Override
        public void onEvent(NeonEventType type, INeonEvent ne) {
            this.events.put(ne.getKey(), ne);
        }

        public void clear() {
            this.events.clear();
        }
    }

    private static final class NeonLocationCache
    implements INeonLocationListener {
        NeonLocation loc = null;

        private NeonLocationCache() {
        }

        @Override
        public void onLocationChanged(NeonLocation location) {
            this.loc = location;
        }

        public void clear() {
            this.loc = null;
        }
    }

    private static interface Delegate<T> {
        public void run(T var1);
    }

    public static class FileWithStatus
    implements AutoCloseable {
        private ParcelFileDescriptor file;
        private FileStatus status;

        public FileStatus getStatus() {
            return this.status;
        }

        public FileDescriptor getFileDescriptor() {
            if (this.file == null) {
                return null;
            }
            return this.file.getFileDescriptor();
        }

        @Override
        public void close() {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.file = null;
            this.status = FileStatus.CLOSED;
        }

        public static enum FileStatus {
            SUCCESS,
            CONNECTIVITY_FAILURE,
            FATAL_FAILURE,
            CLOSED;

        }
    }

    private static class ToHandlerOnChangeBoolean
    extends OnChangeBoolean.Stub {
        private final Handler mHandler;
        private final OnChangeBoolean mOnChangeBoolean;

        public ToHandlerOnChangeBoolean(Handler handler, OnChangeBoolean onChangeBoolean) {
            this.mHandler = handler;
            this.mOnChangeBoolean = onChangeBoolean;
        }

        @Override
        public void onChange(final boolean success) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ToHandlerOnChangeBoolean.this.mOnChangeBoolean != null) {
                            ToHandlerOnChangeBoolean.this.mOnChangeBoolean.onChange(success);
                        }
                    }
                    catch (RemoteException e) {
                        Log.e((String)NeonImpl.LOG_TAG, (String)"in toHandlerOnChangeBoolean", (Throwable)e);
                    }
                }
            });
        }
    }
}

