/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model;


import android.os.Parcel;
import android.os.Parcelable;

import java.util.UUID;

/**
 * Global location in degrees (WGS-84)
 */
public class PointOfInterest implements Parcelable{
    /**
     * Friendly name for the point-of-interest
     */
    public final String Name;

    /**
     * Unique identifier for the point-of-interest
     */
    public final UUID ID;

    public PointOfInterest(String name, UUID id)
    {
        this.Name = name;
        this.ID = id;
    }

    @Override
    public String toString()
    {
        return this.Name + ", " + this.ID;
    }

    /**
     * Used for sending data across binders
     */
    public static final Parcelable.Creator<PointOfInterest> CREATOR = new Parcelable.Creator<PointOfInterest>() {
        @Override
        public PointOfInterest createFromParcel(Parcel in) {
            return new PointOfInterest(in);
        }

        @Override
        public PointOfInterest[] newArray(int size) {
            return new PointOfInterest[size];
        }
    };

    PointOfInterest(Parcel in)
    {
        Name = in.readString();
        ID = UUID.fromString(in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(Name);
        dest.writeString(ID.toString());
    }
}


