/******************************************************************************
 * 		
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 * 
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *   
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 * 
 *****************************************************************************/
package com.trx.neon.api.neon.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.neonEnvironment.model.DownloadOptions;

/**
 * Status result on download operations to the Neon Location Service
 * @author Travis
 *
 */
public enum LoginResult implements Parcelable
{
	/** There are no stored credentials, start activity to login to NLS */
	NO_CREDENTIALS_SET,
	/** NLS must be upgraded in order to log in */
	MANDATORY_UPDATE_REQUIRED,
	/** Google account must be refreshed before continuing */
	GOOGLE_ACTIVITY_REQUIRED,
	/** Can't log in because there is no Internet access */
	NO_INTERNET,
	/** We have successfully downloaded logged in to the NLS */
	SUCCESS;

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(ordinal());
	}

	@Override
	public int describeContents() {
		return 0;
	}

	public static final Creator<LoginResult> CREATOR = new Creator<LoginResult>() {
		@Override
		public LoginResult createFromParcel(Parcel in) {
			int value = in.readInt();

			if(value >= DownloadOptions.values().length)
				return LoginResult.values()[0];
			return LoginResult.values()[value];
		}

		@Override
		public LoginResult[] newArray(int size) {
			return new LoginResult[size];
		}
	};
}
