/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonRouting.model;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.UUID;

public class RouteNode
implements Parcelable {
    public final UUID ID;
    public final UUID BuildingID;
    public final Integer Floor;
    public final double Latitude;
    public final double Longitude;
    public final String Type;
    public static final Parcelable.Creator<RouteNode> CREATOR = new Parcelable.Creator<RouteNode>(){

        public RouteNode createFromParcel(Parcel in) {
            return new RouteNode(in);
        }

        public RouteNode[] newArray(int size) {
            return new RouteNode[size];
        }
    };

    public RouteNode(UUID id, UUID buildingID, Integer floor, double latitude, double longitude, String type) {
        this.ID = id;
        this.BuildingID = buildingID;
        this.Floor = floor;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.Type = type;
    }

    public String toString() {
        return this.ID + ", " + this.BuildingID + ", " + (this.Floor == null ? "None" : this.Floor) + ", " + this.Latitude + ", " + this.Longitude + ", " + this.Type;
    }

    RouteNode(Parcel in) {
        this.ID = UUID.fromString(in.readString());
        this.BuildingID = UUID.fromString(in.readString());
        boolean hasFloor = in.readByte() != 0;
        this.Floor = hasFloor ? Integer.valueOf(in.readInt()) : null;
        this.Latitude = in.readDouble();
        this.Longitude = in.readDouble();
        this.Type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.ID.toString());
        dest.writeString(this.BuildingID.toString());
        if (this.Floor == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.Floor.intValue());
        }
        dest.writeDouble(this.Latitude);
        dest.writeDouble(this.Longitude);
        dest.writeString(this.Type);
    }
}

