/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonRouting.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neonRouting.model.RouteNode;
import com.trx.neon.api.neonRouting.model.types.RouteFilterType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class Route
implements Parcelable {
    public final UUID ID;
    public final String Destination;
    public final int MinutesToDestination;
    public final int MetersToDestination;
    public final List<RouteFilterType> FiltersOnRoute;
    public final LinkedList<RouteNode> Nodes;
    public static final Parcelable.Creator<Route> CREATOR = new Parcelable.Creator<Route>(){

        public Route createFromParcel(Parcel in) {
            return new Route(in);
        }

        public Route[] newArray(int size) {
            return new Route[size];
        }
    };

    public String toString() {
        return this.ID + ", " + this.Nodes.size();
    }

    public Route(UUID id, String destination, int minutesToDestination, int metersToDestination, List<RouteFilterType> filtersOnRoute, LinkedList<RouteNode> nodes) {
        this.ID = id;
        this.Destination = destination;
        this.MinutesToDestination = minutesToDestination;
        this.MetersToDestination = metersToDestination;
        this.FiltersOnRoute = new ArrayList<RouteFilterType>(filtersOnRoute);
        this.Nodes = new LinkedList<RouteNode>(nodes);
    }

    Route(Parcel in) {
        this.ID = UUID.fromString(in.readString());
        this.Destination = in.readString();
        this.MinutesToDestination = in.readInt();
        this.MetersToDestination = in.readInt();
        this.FiltersOnRoute = in.createTypedArrayList(RouteFilterType.CREATOR);
        this.Nodes = new LinkedList(in.createTypedArrayList(RouteNode.CREATOR));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.ID.toString());
        dest.writeString(this.Destination);
        dest.writeInt(this.MinutesToDestination);
        dest.writeInt(this.MetersToDestination);
        dest.writeTypedList(this.FiltersOnRoute);
        dest.writeTypedList(new ArrayList<RouteNode>(this.Nodes));
    }
}

