/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonEnvironment;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.trx.neon.api._internal.NeonImpl;
import com.trx.neon.api.neon.Neon;
import com.trx.neon.api.neon.model.PositionConstraint;
import com.trx.neon.api.neonBeta.model.ElevationInfo;
import com.trx.neon.api.neonBeta.model.ManualConstraint;
import com.trx.neon.api.neonEnvironment.model.DownloadOptions;
import com.trx.neon.api.neonEnvironment.model.LatLongRect;
import com.trx.neon.api.neonEnvironment.model.NeonBuilding;
import com.trx.neon.api.neonEnvironment.model.NeonBuildingFloor;
import com.trx.neon.api.neonEnvironment.model.interfaces.INeonBuildingListener;
import com.trx.neon.api.neonEnvironment.model.interfaces.INeonFloorPlanListener;
import java.util.UUID;

public class NeonEnvironment
extends Neon {
    public static void downloadBuildingsInArea(LatLongRect bounds, INeonBuildingListener callback) {
        NeonImpl.checkLocation(bounds.Northeast.Latitude, bounds.Northeast.Longitude);
        NeonImpl.checkLocation(bounds.Southwest.Latitude, bounds.Southwest.Longitude);
        NeonImpl.neon.downloadBuildingsInArea(bounds, new Handler(Looper.getMainLooper()), callback, DownloadOptions.CACHED);
    }

    public static void downloadBuildingsInArea(LatLongRect bounds, Handler h, INeonBuildingListener callback) {
        NeonImpl.checkLocation(bounds.Northeast.Latitude, bounds.Northeast.Longitude);
        NeonImpl.checkLocation(bounds.Southwest.Latitude, bounds.Southwest.Longitude);
        NeonImpl.neon.downloadBuildingsInArea(bounds, h, callback, DownloadOptions.CACHED);
    }

    public static void downloadBuildingsInArea(LatLongRect bounds, Handler h, INeonBuildingListener listener, DownloadOptions downloadOptions) {
        NeonImpl.checkLocation(bounds.Northeast.Latitude, bounds.Northeast.Longitude);
        NeonImpl.checkLocation(bounds.Southwest.Latitude, bounds.Southwest.Longitude);
        NeonImpl.neon.downloadBuildingsInArea(bounds, h, listener, downloadOptions);
    }

    public static NeonBuilding getBuilding(UUID id) {
        return NeonImpl.neon.getBuilding(id);
    }

    public static void downloadFloorPlan(Context context, NeonBuildingFloor floor, Handler h, INeonFloorPlanListener listener) {
        NeonImpl.neon.getFloorPlan(context, floor, h, listener);
    }

    public static void addBuildingConstraint(PositionConstraint constraint, UUID buildingID, int floor) {
        NeonImpl.checkLocation(constraint.getLatitude(), constraint.getLongitude());
        NeonImpl.neon.addManualConstraint(new ManualConstraint(constraint.getLatitude(), constraint.getLongitude(), constraint.getError(), ElevationInfo.OnFloor(buildingID, floor)));
    }
}

