/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta;

import android.os.SystemClock;
import com.trx.neon.api._internal.NeonImpl;
import com.trx.neon.api.neon.Neon;
import com.trx.neon.api.neonBeta.model.DebugLocation;
import com.trx.neon.api.neonBeta.model.GPSConstraint;
import com.trx.neon.api.neonBeta.model.LineSegmentConstraint;
import com.trx.neon.api.neonBeta.model.ManualConstraint;
import com.trx.neon.api.neonBeta.model.NeonInertialDelta;
import com.trx.neon.api.neonBeta.model.RangingConstraint;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventListenerBeta;
import com.trx.neon.api.neonBeta.model.types.NeonEventTypeBeta;
import java.util.EnumSet;

public class NeonBeta
extends Neon {
    public static void registerEventsBeta(INeonEventListenerBeta listener) {
        NeonBeta.registerEventsBeta(listener, EnumSet.allOf(NeonEventTypeBeta.class));
    }

    private static void registerEventsBeta(INeonEventListenerBeta listener, EnumSet<NeonEventTypeBeta> events) {
        NeonImpl.neon.registerEventsBeta(listener, events);
    }

    public static boolean unregisterEventsBeta(INeonEventListenerBeta listener) {
        return NeonImpl.neon.unregisterEventsBeta(listener);
    }

    public static void addRangingConstraint(RangingConstraint constraint) {
        NeonImpl.checkLocation(constraint.Latitude, constraint.Longitude);
        NeonImpl.neon.addRangingConstraint(constraint);
    }

    public static void addManualConstraint(ManualConstraint constraint) {
        NeonImpl.checkLocation(constraint.Latitude, constraint.Longitude);
        NeonImpl.neon.addManualConstraint(constraint);
    }

    public static void addGPSConstraint(GPSConstraint constraint) {
        NeonImpl.checkLocation(constraint.Latitude, constraint.Longitude);
        NeonImpl.neon.addGPSConstraint(constraint);
    }

    public static void addLineSegmentConstraint(LineSegmentConstraint constraint) {
        NeonImpl.checkLocation(constraint.StartLatitude, constraint.StartLongitude);
        NeonImpl.checkLocation(constraint.EndLatitude, constraint.EndLongitude);
        NeonImpl.neon.addLineSegmentConstraint(constraint);
    }

    public static void processInertialDelta(NeonInertialDelta delta) {
        NeonImpl.neon.processInertialDelta(delta);
    }

    public static void addDebugLocation(DebugLocation dl) {
        NeonImpl.neon.addDebugLocation(dl);
    }

    public static long getNeonTimeMs() {
        return SystemClock.elapsedRealtime() + NeonImpl.neon.getElapsedRealtimeOffset();
    }

    public static long getNeonTimeMs(long elapsedRealtime) {
        return elapsedRealtime + NeonImpl.neon.getElapsedRealtimeOffset();
    }
}

