/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventType;

public class SessionEvent
implements Parcelable,
INeonEvent {
    public final int serialNumber;
    public final int session;
    public final String deviceType;
    public static final Parcelable.Creator<SessionEvent> CREATOR = new Parcelable.Creator<SessionEvent>(){

        public SessionEvent createFromParcel(Parcel in) {
            return new SessionEvent(in);
        }

        public SessionEvent[] newArray(int size) {
            return new SessionEvent[size];
        }
    };

    public DeviceType getDeviceType() {
        try {
            return Enum.valueOf(DeviceType.class, this.deviceType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public SessionEvent(int id, int session, DeviceType deviceType) {
        this.serialNumber = id;
        this.session = session;
        this.deviceType = deviceType.name();
    }

    private SessionEvent(Parcel in) {
        this.serialNumber = in.readInt();
        this.session = in.readInt();
        this.deviceType = in.readString();
    }

    @Override
    public String getKey() {
        return NeonEventType.SESSION.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.SESSION;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SessionEvent) {
            return ((SessionEvent)o).serialNumber == this.serialNumber && ((SessionEvent)o).session == this.session;
        }
        return false;
    }

    public int hashCode() {
        return this.serialNumber + this.session * 3;
    }

    public String toString() {
        return "(PID: " + this.serialNumber + ":" + this.session + "[" + this.deviceType + "])";
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.serialNumber);
        out.writeInt(this.session);
        out.writeString(this.deviceType);
    }

    public static enum DeviceType {
        INU8_BLE,
        INU8_UWB,
        PHONE;

    }
}

