/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class NavLockEvent
implements Parcelable,
INeonEvent {
    public final long unixTimeMs;
    private final byte value;
    public static final Parcelable.Creator<NavLockEvent> CREATOR = new Parcelable.Creator<NavLockEvent>(){

        public NavLockEvent createFromParcel(Parcel in) {
            return new NavLockEvent(in);
        }

        public NavLockEvent[] newArray(int size) {
            return new NavLockEvent[size];
        }
    };

    public boolean getLocationLock() {
        return (this.value & 1) > 0;
    }

    public boolean getHeadingLock() {
        return (this.value & 2) > 0;
    }

    public boolean getElevationLock() {
        return (this.value & 4) > 0;
    }

    public boolean getScaleLock() {
        return (this.value & 8) > 0;
    }

    public boolean getDriftLock() {
        return (this.value & 0x10) > 0;
    }

    public boolean getInsideBuilding() {
        return (this.value & 0x20) > 0;
    }

    public int getNavLockBars() {
        int navLockLevel = 0;
        if (this.getLocationLock()) {
            navLockLevel = 1;
            if (this.getHeadingLock()) {
                navLockLevel = 2;
                if (this.getScaleLock()) {
                    navLockLevel = 3;
                    if (this.getDriftLock()) {
                        navLockLevel = 4;
                    }
                }
            }
        }
        return navLockLevel;
    }

    public NavLockEvent(long unixTimeMs, byte lockValue) {
        this.unixTimeMs = unixTimeMs;
        this.value = lockValue;
    }

    private NavLockEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.value = in.readByte();
    }

    @Override
    public String getKey() {
        return NeonEventType.NAV_LOCK.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.NAV_LOCK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeByte(this.value);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Location Lock: " + this.getLocationLock() + "; Heading Lock: " + this.getHeadingLock() + "; Elevation Lock: " + this.getElevationLock() + "; Scale Lock: " + this.getScaleLock() + "; Drift Lock: " + this.getDriftLock() + "; InsideBuilding: " + this.getInsideBuilding();
    }
}

