/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class MotionLevelEvent
implements Parcelable,
INeonEvent {
    public final long unixTimeMs;
    private final String type;
    public static final Parcelable.Creator<MotionLevelEvent> CREATOR = new Parcelable.Creator<MotionLevelEvent>(){

        public MotionLevelEvent createFromParcel(Parcel in) {
            return new MotionLevelEvent(in);
        }

        public MotionLevelEvent[] newArray(int size) {
            return new MotionLevelEvent[size];
        }
    };

    public MotionLevelEventType getType() {
        try {
            return Enum.valueOf(MotionLevelEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getKey() {
        return NeonEventType.MOTION_LEVEL.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.MOTION_LEVEL;
    }

    public MotionLevelEvent(long unixTimeMs, MotionLevelEventType type) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
    }

    private MotionLevelEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum MotionLevelEventType {
        UNKNOWN,
        NONE,
        LOW,
        HIGH;

    }
}

