/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class BatteryEvent
implements Parcelable,
INeonEvent {
    public final long unixTimeMs;
    public final String sourceID;
    public final String sourceType;
    public final byte percent;
    public static final Parcelable.Creator<BatteryEvent> CREATOR = new Parcelable.Creator<BatteryEvent>(){

        public BatteryEvent createFromParcel(Parcel in) {
            return new BatteryEvent(in);
        }

        public BatteryEvent[] newArray(int size) {
            return new BatteryEvent[size];
        }
    };

    @Override
    public String getKey() {
        return NeonEventType.BATTERY.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.BATTERY;
    }

    public BatteryEvent(long unixTimeMs, String sourceID, String sourceType, byte percent) {
        this.unixTimeMs = unixTimeMs;
        this.sourceID = sourceID;
        this.sourceType = sourceType;
        this.percent = percent;
    }

    private BatteryEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.sourceID = in.readString();
        this.sourceType = in.readString();
        this.percent = in.readByte();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.sourceID);
        dest.writeString(this.sourceType);
        dest.writeByte(this.percent);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "SourceID: " + this.sourceID + ", " + "SourceType: " + this.sourceType + ", " + "Percent: " + this.percent;
    }
}

