/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class NeonLocation
implements Parcelable {
    public final int serialNumber;
    public final int sessionID;
    public final long unixTimeMs;
    public final int iteration;
    public final String type;
    public final double longitude;
    public final double latitude;
    public final float heading;
    public final float headingError;
    public final double errorLongitude;
    public final double errorLatitude;
    public final float errorRadius;
    public final float altitude;
    public final float altitudeError;
    public final UUID structureID;
    public final Float z;
    public final Float zError;
    public final byte batteryHH;
    public final byte batteryTU;
    public final float scale;
    public final float scaleError;
    public final float drift;
    public final float driftError;
    public static final Parcelable.Creator<NeonLocation> CREATOR = new Parcelable.Creator<NeonLocation>(){

        public NeonLocation createFromParcel(Parcel in) {
            return new NeonLocation(in);
        }

        public NeonLocation[] newArray(int size) {
            return new NeonLocation[size];
        }
    };
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());

    public NeonLocation(int serial, int session, long unixTimeMs, int navIter, String type, double longitude, double latitude, float heading, float headingError, double errorLongitude, double errorLatitude, float errorRadius, float altitude, float altitudeError, UUID structureID, Float z, Float zError, byte batteryAndroid, byte batteryTrackingUnit, float scale, float scaleError, float drift, float driftError) {
        this.serialNumber = serial;
        this.sessionID = session;
        this.unixTimeMs = unixTimeMs;
        this.iteration = navIter;
        this.type = type;
        this.longitude = longitude;
        this.latitude = latitude;
        this.heading = heading;
        this.headingError = headingError;
        this.errorLongitude = errorLongitude;
        this.errorLatitude = errorLatitude;
        this.errorRadius = errorRadius;
        this.altitude = altitude;
        this.altitudeError = altitudeError;
        this.structureID = structureID;
        this.z = z;
        this.zError = zError;
        this.batteryHH = batteryAndroid;
        this.batteryTU = batteryTrackingUnit;
        this.scale = scale;
        this.scaleError = scaleError;
        this.drift = drift;
        this.driftError = driftError;
    }

    public NeonLocation(NeonLocation loc) {
        this.serialNumber = loc.serialNumber;
        this.sessionID = loc.sessionID;
        this.unixTimeMs = loc.unixTimeMs;
        this.iteration = loc.iteration;
        this.type = loc.type;
        this.longitude = loc.longitude;
        this.latitude = loc.latitude;
        this.heading = loc.heading;
        this.headingError = loc.headingError;
        this.errorLongitude = loc.errorLongitude;
        this.errorLatitude = loc.errorLatitude;
        this.errorRadius = loc.errorRadius;
        this.altitude = loc.altitude;
        this.altitudeError = loc.altitudeError;
        this.structureID = loc.structureID;
        this.z = loc.z;
        this.zError = loc.zError;
        this.batteryHH = loc.batteryHH;
        this.batteryTU = loc.batteryTU;
        this.scale = loc.scale;
        this.scaleError = loc.scaleError;
        this.drift = loc.drift;
        this.driftError = loc.driftError;
    }

    public Float getFloor() {
        return this.z;
    }

    public Float getFloorError() {
        return this.zError;
    }

    public Integer getNearestFloor() {
        return this.z != null ? Integer.valueOf(Math.round(this.z.floatValue())) : null;
    }

    public Location toLocation() {
        return this.toLocation("Neon");
    }

    private Location toLocation(String providerName) {
        Location loc = new Location(providerName);
        loc.setAccuracy(this.errorRadius);
        loc.setAltitude((double)this.altitude);
        loc.setBearing(this.heading);
        loc.setLatitude(this.latitude);
        loc.setLongitude(this.longitude);
        loc.setTime(this.unixTimeMs);
        return loc;
    }

    private NeonLocation(Parcel in) {
        boolean hasBuildingZ;
        this.serialNumber = in.readInt();
        this.sessionID = in.readInt();
        this.unixTimeMs = in.readLong();
        this.iteration = in.readInt();
        this.type = in.readString();
        this.longitude = in.readDouble();
        this.latitude = in.readDouble();
        this.heading = in.readFloat();
        this.headingError = in.readFloat();
        this.errorLongitude = in.readDouble();
        this.errorLatitude = in.readDouble();
        this.errorRadius = in.readFloat();
        this.altitude = in.readFloat();
        this.altitudeError = in.readFloat();
        boolean bl = hasBuildingZ = in.readByte() != 0;
        if (hasBuildingZ) {
            long mostSig = in.readLong();
            long leastSig = in.readLong();
            this.structureID = new UUID(mostSig, leastSig);
            this.z = Float.valueOf(in.readFloat());
            this.zError = Float.valueOf(in.readFloat());
        } else {
            this.structureID = null;
            this.z = null;
            this.zError = null;
        }
        this.batteryHH = in.readByte();
        this.batteryTU = in.readByte();
        this.scale = in.readFloat();
        this.scaleError = in.readFloat();
        this.drift = in.readFloat();
        this.driftError = in.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.serialNumber);
        dest.writeInt(this.sessionID);
        dest.writeLong(this.unixTimeMs);
        dest.writeInt(this.iteration);
        dest.writeString(this.type);
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.latitude);
        dest.writeFloat(this.heading);
        dest.writeFloat(this.headingError);
        dest.writeDouble(this.errorLongitude);
        dest.writeDouble(this.errorLatitude);
        dest.writeFloat(this.errorRadius);
        dest.writeFloat(this.altitude);
        dest.writeFloat(this.altitudeError);
        if (this.structureID == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            long mostSig = this.structureID.getMostSignificantBits();
            long leastSig = this.structureID.getLeastSignificantBits();
            dest.writeLong(mostSig);
            dest.writeLong(leastSig);
            dest.writeFloat(this.z.floatValue());
            dest.writeFloat(this.zError.floatValue());
        }
        dest.writeByte(this.batteryHH);
        dest.writeByte(this.batteryTU);
        dest.writeFloat(this.scale);
        dest.writeFloat(this.scaleError);
        dest.writeFloat(this.drift);
        dest.writeFloat(this.driftError);
    }

    public String toString() {
        String sb = "SerialNumber: " + this.serialNumber + ", " + "Session: " + this.sessionID + ", " + "Time: " + DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Iteration: " + this.iteration + ", " + "Type: " + this.type + ", " + "Longitude: " + this.longitude + ", " + "Latitude: " + this.latitude + ", " + "Heading: " + this.heading + ", " + "HeadingError: " + this.headingError + ", " + "ErrorLongitude: " + this.errorLongitude + ", " + "ErrorLatitude: " + this.errorLatitude + ", " + "ErrorRadius: " + this.errorRadius + ", " + "Altitude: " + this.altitude + ", " + "AltitudeError: " + this.altitudeError + ", " + "BatteryHH: " + this.batteryHH + ", " + "BatteryTU: " + this.batteryTU + ", " + "Drift: " + this.drift + ", " + "DriftError: " + this.driftError + ", " + "Scale: " + this.scale + ", " + "ScaleError: " + this.scaleError;
        return sb;
    }

    public static class NeonLocationDisplayInfo {
        public UUID StructureID;
        public float DisplayZ;
        public float DisplayZError;

        public NeonLocationDisplayInfo() {
        }

        public NeonLocationDisplayInfo(NeonLocationDisplayInfo toCopy) {
            this.StructureID = toCopy.StructureID;
            this.DisplayZ = toCopy.DisplayZ;
            this.DisplayZError = toCopy.DisplayZError;
        }

        public NeonLocationDisplayInfo(UUID structureID, float displayZ, float displayZError) {
            this.StructureID = structureID;
            this.DisplayZ = displayZ;
            this.DisplayZError = displayZError;
        }
    }
}

