/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api._internal.legacy;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

@Deprecated
public class NeonLocationLegacyV4
implements Parcelable {
    @Deprecated
    public final int serialNumber;
    @Deprecated
    public final int sessionID;
    @Deprecated
    public final long unixTimeMs;
    @Deprecated
    public final int iteration;
    @Deprecated
    public final double longitude;
    @Deprecated
    public final double latitude;
    @Deprecated
    public final float heading;
    @Deprecated
    public final float headingError;
    @Deprecated
    public final double errorLongitude;
    @Deprecated
    public final double errorLatitude;
    @Deprecated
    public final float errorRadius;
    @Deprecated
    public final Float floor;
    @Deprecated
    public final Float floorError;
    @Deprecated
    public final float altitude;
    @Deprecated
    public final boolean underground;
    @Deprecated
    public final float altitudeError;
    @Deprecated
    public final byte batteryHH;
    @Deprecated
    public final byte batteryTU;
    @Deprecated
    public final UUID buildingID;
    @Deprecated
    public final int buildingRevision;
    @Deprecated
    public final float scale;
    @Deprecated
    public final float scaleError;
    @Deprecated
    public final float drift;
    @Deprecated
    public final float driftError;
    public static final UUID NoBuilding = new UUID(0L, 0L);
    public static final Parcelable.Creator<NeonLocationLegacyV4> CREATOR = new Parcelable.Creator<NeonLocationLegacyV4>(){

        public NeonLocationLegacyV4 createFromParcel(Parcel in) {
            return new NeonLocationLegacyV4(in);
        }

        public NeonLocationLegacyV4[] newArray(int size) {
            return new NeonLocationLegacyV4[size];
        }
    };
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());

    public NeonLocationLegacyV4(int serial, int session, long unixTimeMs, int navIter, double longitude, double latitude, float heading, float headingError, double errorLongitude, double errorLatitude, float errorRadius, Float floor, Float floorError, float altitude, float altitudeError, boolean underground, byte batteryAndroid, byte batteryTrackingUnit, UUID buildingID, int buildingRevision, float scale, float scaleError, float drift, float driftError) {
        this.serialNumber = serial;
        this.sessionID = session;
        this.unixTimeMs = unixTimeMs;
        this.iteration = navIter;
        this.longitude = longitude;
        this.latitude = latitude;
        this.heading = heading;
        this.headingError = headingError;
        this.errorLongitude = errorLongitude;
        this.errorLatitude = errorLatitude;
        this.errorRadius = errorRadius;
        this.floor = floor;
        this.floorError = floorError;
        this.altitude = altitude;
        this.altitudeError = altitudeError;
        this.underground = underground;
        this.batteryHH = batteryAndroid;
        this.batteryTU = batteryTrackingUnit;
        this.buildingID = buildingID;
        this.buildingRevision = buildingRevision;
        this.scale = scale;
        this.scaleError = scaleError;
        this.drift = drift;
        this.driftError = driftError;
    }

    public NeonLocationLegacyV4(NeonLocationLegacyV4 loc) {
        this.serialNumber = loc.serialNumber;
        this.sessionID = loc.sessionID;
        this.unixTimeMs = loc.unixTimeMs;
        this.iteration = loc.iteration;
        this.longitude = loc.longitude;
        this.latitude = loc.latitude;
        this.heading = loc.heading;
        this.headingError = loc.headingError;
        this.errorLongitude = loc.errorLongitude;
        this.errorLatitude = loc.errorLatitude;
        this.errorRadius = loc.errorRadius;
        this.floor = loc.floor;
        this.floorError = loc.floorError;
        this.altitude = loc.altitude;
        this.altitudeError = loc.altitudeError;
        this.underground = loc.underground;
        this.batteryHH = loc.batteryHH;
        this.batteryTU = loc.batteryTU;
        this.buildingID = loc.buildingID;
        this.buildingRevision = loc.buildingRevision;
        this.scale = loc.scale;
        this.scaleError = loc.scaleError;
        this.drift = loc.drift;
        this.driftError = loc.driftError;
    }

    public Location toLocation() {
        return this.toLocation("Neon");
    }

    private Location toLocation(String providerName) {
        Location loc = new Location(providerName);
        loc.setAccuracy(this.errorRadius);
        loc.setAltitude((double)this.altitude);
        loc.setBearing(this.heading);
        loc.setLatitude(this.latitude);
        loc.setLongitude(this.longitude);
        loc.setTime(this.unixTimeMs);
        return loc;
    }

    private NeonLocationLegacyV4(Parcel in) {
        this.serialNumber = in.readInt();
        this.sessionID = in.readInt();
        this.unixTimeMs = in.readLong();
        this.iteration = in.readInt();
        this.longitude = in.readDouble();
        this.latitude = in.readDouble();
        this.heading = in.readFloat();
        this.headingError = in.readFloat();
        this.errorLongitude = in.readDouble();
        this.errorLatitude = in.readDouble();
        this.errorRadius = in.readFloat();
        this.floor = in.readByte() > 0 ? Float.valueOf(in.readFloat()) : null;
        this.floorError = in.readByte() > 0 ? Float.valueOf(in.readFloat()) : null;
        this.altitude = in.readFloat();
        this.altitudeError = in.readFloat();
        this.underground = in.readByte() > 0;
        this.batteryHH = in.readByte();
        this.batteryTU = in.readByte();
        this.buildingID = new UUID(in.readLong(), in.readLong());
        this.buildingRevision = in.readInt();
        this.scale = in.readFloat();
        this.scaleError = in.readFloat();
        this.drift = in.readFloat();
        this.driftError = in.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.serialNumber);
        dest.writeInt(this.sessionID);
        dest.writeLong(this.unixTimeMs);
        dest.writeInt(this.iteration);
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.latitude);
        dest.writeFloat(this.heading);
        dest.writeFloat(this.headingError);
        dest.writeDouble(this.errorLongitude);
        dest.writeDouble(this.errorLatitude);
        dest.writeFloat(this.errorRadius);
        dest.writeByte((byte)(this.floor != null ? 1 : 0));
        if (this.floor != null) {
            dest.writeFloat(this.floor.floatValue());
        }
        dest.writeByte((byte)(this.floorError != null ? 1 : 0));
        if (this.floorError != null) {
            dest.writeFloat(this.floorError.floatValue());
        }
        dest.writeFloat(this.altitude);
        dest.writeFloat(this.altitudeError);
        dest.writeByte(this.underground ? (byte)1 : 0);
        dest.writeByte(this.batteryHH);
        dest.writeByte(this.batteryTU);
        dest.writeLong(this.buildingID.getMostSignificantBits());
        dest.writeLong(this.buildingID.getLeastSignificantBits());
        dest.writeInt(this.buildingRevision);
        dest.writeFloat(this.scale);
        dest.writeFloat(this.scaleError);
        dest.writeFloat(this.drift);
        dest.writeFloat(this.driftError);
    }

    public String toString() {
        String sb = "SerialNumber: " + this.serialNumber + ", " + "Session: " + this.sessionID + ", " + "Time: " + DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Iteration: " + this.iteration + ", " + "Longitude: " + this.longitude + ", " + "Latitude: " + this.latitude + ", " + "Heading: " + this.heading + ", " + "HeadingError: " + this.headingError + ", " + "ErrorLongitude: " + this.errorLongitude + ", " + "ErrorLatitude: " + this.errorLatitude + ", " + "ErrorRadius: " + this.errorRadius + ", " + "Floor: " + this.floor + ", " + "FloorError: " + this.floorError + ", " + "Altitude: " + this.altitude + ", " + "AltitudeError: " + this.altitudeError + ", " + "Underground: " + this.underground + ", " + "BatteryHH: " + this.batteryHH + ", " + "BatteryTU: " + this.batteryTU + ", " + "Building: " + this.buildingID + " revision " + this.buildingRevision + ", " + "Drift: " + this.drift + ", " + "DriftError: " + this.driftError + ", " + "Scale: " + this.scale + ", " + "ScaleError: " + this.scaleError;
        return sb;
    }
}

