/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model.types;

import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.neonEnvironment.model.DownloadOptions;

/**
 *
 * @author Travis
 *
 */
public enum RouteInstructionType implements Parcelable
{
	/** Direction to reach next node */
	START,
	END,
	STRAIGHT,
	U_TURN,
	SLIGHT_LEFT,
	SLIGHT_RIGHT,
	SHARP_LEFT,
	SHARP_RIGHT,
	LEFT,
	RIGHT,
	UP,
	DOWN,
	ENTER_BUILDING,
	EXIT_BUILDING,
	ERROR,
	NONE;

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(ordinal());
	}

	@Override
	public int describeContents() {
		return 0;
	}

	public static final Creator<RouteInstructionType> CREATOR = new Creator<RouteInstructionType>() {
		@Override
		public RouteInstructionType createFromParcel(Parcel in) {
			int value = in.readInt();

			if(value >= RouteInstructionType.values().length)
				return RouteInstructionType.values()[0];
			return RouteInstructionType.values()[value];
		}

		@Override
		public RouteInstructionType[] newArray(int size) {
			return new RouteInstructionType[size];
		}
	};
}
