/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model.types;

import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.neonEnvironment.model.DownloadOptions;

/**
 * Status result on download operations to the Neon Location Service
 * @author Travis
 *
 */
public enum RouteFilterType implements Parcelable
{
	/** There are no stored credentials, start activity to login to NLS */
	STAIRS,
	ELEVATORS,
	ESCALATORS,
	RAMPS;

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(ordinal());
	}

	@Override
	public int describeContents() {
		return 0;
	}

	public static final Creator<RouteFilterType> CREATOR = new Creator<RouteFilterType>() {
		@Override
		public RouteFilterType createFromParcel(Parcel in) {
			int value = in.readInt();

			if(value >= RouteFilterType.values().length)
				return RouteFilterType.values()[0];
			return RouteFilterType.values()[value];
		}

		@Override
		public RouteFilterType[] newArray(int size) {
			return new RouteFilterType[size];
		}
	};
}
