/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 *
 *
 */
public enum RoutingResult implements Parcelable
{
	/** routing service has not been started */
	ROUTING_SERVICE_NOT_CONNECTED,
	/** routing to node was successful */
	SUCCESS,
	/** It is not possible to route to this node */
	NO_ROUTE_FOUND;

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(ordinal());
	}

	@Override
	public int describeContents() {
		return 0;
	}

	public static final Creator<RoutingResult> CREATOR = new Creator<RoutingResult>() {
		@Override
		public RoutingResult createFromParcel(Parcel in) {
			int value = in.readInt();

			if(value >= RoutingResult.values().length)
				return RoutingResult.values()[0];
			return RoutingResult.values()[value];
		}

		@Override
		public RoutingResult[] newArray(int size) {
			return new RoutingResult[size];
		}
	};
}
