/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model;


import android.os.Parcel;
import android.os.Parcelable;

import java.util.UUID;

/**
 * Global location in degrees (WGS-84)
 */
public class RouteNode implements Parcelable{

    /**
     * Unique identifier for the point-of-interest
     */
    public final UUID ID;

    public final UUID BuildingID;

    public final Integer Floor;

    public final double Latitude;
    public final double Longitude;

    public final String Type;

    public RouteNode(UUID id, UUID buildingID, Integer floor, double latitude, double longitude, String type)
    {
        this.ID = id;
        this.BuildingID = buildingID;
        this.Floor = floor;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.Type = type;
    }

    @Override
    public String toString()
    {
        return this.ID + ", " + this.BuildingID+", "+(this.Floor == null?"None":Floor)+", "+Latitude+", "+Longitude+", "+Type;
    }

    /**
     * Used for sending data across binders
     */
    public static final Creator<RouteNode> CREATOR = new Creator<RouteNode>() {
        @Override
        public RouteNode createFromParcel(Parcel in) {
            return new RouteNode(in);
        }

        @Override
        public RouteNode[] newArray(int size) {
            return new RouteNode[size];
        }
    };

    RouteNode(Parcel in)
    {
        ID = UUID.fromString(in.readString());
        BuildingID = UUID.fromString(in.readString());
        boolean hasFloor = in.readByte() != 0;
        if (hasFloor)
            Floor = in.readInt();
        else Floor = null;
        Latitude = in.readDouble();
        Longitude = in.readDouble();
        Type = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(ID.toString());
        dest.writeString(BuildingID.toString());
        if (Floor == null)
            dest.writeByte((byte) 0);
        else
        {
            dest.writeByte((byte)1);
            dest.writeInt(Floor);
        }
        dest.writeDouble(Latitude);
        dest.writeDouble(Longitude);
        dest.writeString(Type);
    }
}


