package com.trx.neon.api.neonRouting.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.neonRouting.model.types.RouteFilterType;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

/**
 * Created by Travis on 5/18/2018.
 */

public class Route implements Parcelable{

    /**
     * Unique identifier for the route
     */
    public final UUID ID;

    public final String Destination;

    public final int MinutesToDestination;

    public final int MetersToDestination;

    public final List<RouteFilterType> FiltersOnRoute;

    public final LinkedList<RouteNode> Nodes;

    @Override
    public String toString()
    {
        return this.ID + ", " + this.Nodes.size();
    }

    public Route(UUID id, String destination, int minutesToDestination, int metersToDestination, List<RouteFilterType> filtersOnRoute, LinkedList<RouteNode> nodes)
    {
        ID = id;
        Destination = destination;
        MinutesToDestination = minutesToDestination;
        MetersToDestination = metersToDestination;
        FiltersOnRoute = new ArrayList<>(filtersOnRoute);
        Nodes = new LinkedList<>(nodes);
    }

    /**
     * Used for sending data across binders
     */
    public static final Parcelable.Creator<Route> CREATOR = new Parcelable.Creator<Route>() {
        @Override
        public Route createFromParcel(Parcel in) {
            return new Route(in);
        }

        @Override
        public Route[] newArray(int size) {
            return new Route[size];
        }
    };

    Route(Parcel in)
    {
        ID = UUID.fromString(in.readString());
        Destination = in.readString();
        MinutesToDestination = in.readInt();
        MetersToDestination = in.readInt();
        FiltersOnRoute = in.createTypedArrayList(RouteFilterType.CREATOR);
        Nodes = new LinkedList<>(in.createTypedArrayList(RouteNode.CREATOR));

    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(ID.toString());
        dest.writeString(Destination);
        dest.writeInt(MinutesToDestination);
        dest.writeInt(MetersToDestination);
        dest.writeTypedList(FiltersOnRoute);
        dest.writeTypedList(new ArrayList<>(Nodes));
    }

}
