/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model;


import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.BuildConfig;

import java.util.UUID;

/**
 * Global location in degrees (WGS-84)
 */
public class PointOfInterest implements Parcelable{
    /**
     * Friendly name for the point-of-interest
     */
    public final String Name;

    /**
     * Unique identifier for the point-of-interest
     */
    public final UUID ID;

    /**
     * Unique identifier for the building which contains the point of interest
     */
    public final UUID BuildingID;

    /**
     * Friendly name for the building which contains the point of interest
     */
    public final String BuildingLabel;

    /**
     * Unique identifier for the building which contains the point of interest
     */
    public final int FloorNumber;

    /**
     * Friendly name for the floor which contains the point of interest
     */
    public final String FloorLabel;

    public final double Latitude;
    public final double Longitude;



    public PointOfInterest(String name, UUID id, UUID buildingID, String buildingLabel, int floorNumber, String floorLabel, double latitude, double longitude)
    {
        this.Name = name;
        this.ID = id;
        this.BuildingID = buildingID;
        this.BuildingLabel = buildingLabel;
        this.FloorNumber = floorNumber;
        this.FloorLabel = floorLabel;
        this.Latitude = latitude;
        this.Longitude = longitude;
    }

    @Override
    public String toString()
    {
        return this.Name + ", " + this.ID;
    }

    /**
     * Used for sending data across binders
     */
    public static final Parcelable.Creator<PointOfInterest> CREATOR = new Parcelable.Creator<PointOfInterest>() {
        @Override
        public PointOfInterest createFromParcel(Parcel in) {
            return new PointOfInterest(in);
        }

        @Override
        public PointOfInterest[] newArray(int size) {
            return new PointOfInterest[size];
        }
    };

    PointOfInterest(Parcel in)
    {
        Name = in.readString();
        ID = UUID.fromString(in.readString());
        BuildingID = UUID.fromString(in.readString());
        BuildingLabel = in.readString();
        FloorNumber = in.readInt();
        FloorLabel = in.readString();
        Latitude = in.readDouble();
        Longitude = in.readDouble();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(Name);
        dest.writeString(ID.toString());
        dest.writeString(BuildingID.toString());
        dest.writeString(BuildingLabel);
        dest.writeInt(FloorNumber);
        dest.writeString(FloorLabel);
        dest.writeDouble(Latitude);
        dest.writeDouble(Longitude);
    }
}


