/******************************************************************************
 * 		
 * 	 Copyright 2015, TRX Systems, Inc.  All Rights Reserved.
 * 
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *   
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 * 
 *****************************************************************************/
package com.trx.neon.api.neonRouting;

import android.os.Handler;

import com.trx.neon.api.neonEnvironment.model.LatLong;
import com.trx.neon.api.neonRouting.model.PointOfInterest;
import com.trx.neon.api.neonRouting.model.Route;
import com.trx.neon.api.neonRouting.model.interfaces.INeonPointOfInterestListener;
import com.trx.neon.api.neonRouting.model.interfaces.INeonRouteListener;
import com.trx.neon.api.neonRouting.model.interfaces.INeonTurnByTurnListener;
import com.trx.neon.api.neonRouting.model.types.RouteFilterType;

import java.util.List;
import java.util.UUID;

import static com.trx.neon.api._internal.NeonImpl.checkLocation;
import static com.trx.neon.api._internal.NeonImpl.neon;

/**
 * The main entry point for integrating Neon Routing Services into your application.
 * @author Dan
 */
public class NeonRouting {

    /**
     */
    public static void getPointsOfInterest(String buildingID, LatLong currentPosition, Handler h, INeonPointOfInterestListener poiListener) {
        checkLocation(currentPosition.Latitude, currentPosition.Longitude);
        neon.getPointsOfInterest(buildingID, currentPosition, h, poiListener);
    }

    /**
     */
    public static void routeToPointOfInterest(PointOfInterest poi, LatLong currentPosition, int currentFloor, List<RouteFilterType> routeFilters, Handler h, INeonRouteListener routeListener) {
        checkLocation(currentPosition.Latitude, currentPosition.Longitude);
        neon.routeToPointOfInterest(poi, currentPosition, currentFloor, routeFilters, h, routeListener);
    }

    public static void startTurnByTurnNavigation(Route route, LatLong currentPosition, Handler h, INeonTurnByTurnListener turnByTurnListener) {
        checkLocation(currentPosition.Latitude, currentPosition.Longitude);
        neon.startTurnByTurnNavigation(route, currentPosition, h, turnByTurnListener);
    }

    public static void cancelTurnByTurnNavigation() {
        neon.cancelTurnByTurnNavigation();
    }

}
