package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

public class TVIdTamperingResponse extends TVPollingStatusResponse {
    @SerializedName("card_tampering")
    private TVCardTampering cardTampering;

    @SerializedName("image_id")
    private String imageId;

    @SerializedName("image2_id")
    private String image2Id;

    public TVCardTampering getCardTampering() {
        return cardTampering;
    }

    public String getImageId() {
        return imageId;
    }

    public String getImage2Id() {
        return image2Id;
    }

    public class TVCardTampering {
        @SerializedName("scrore")
        private float score;

        @SerializedName("verdict")
        private String verdict;

        public float getScore() {
            return score;
        }

        public String getVerdict() {
            return verdict;
        }

        public TVApiError getError() {
            if (!"good".equalsIgnoreCase(verdict)) {
                return new TVApiError(verdict, verdict);
            }
            return null;
        }
    }
}
